package jp.turbosql.modules.db.app.sqlanalyzer;

import javax.swing.JInternalFrame;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JFrame;
import javax.swing.UIManager;

import java.awt.event.*;
import java.awt.*;

import jp.turbosql.swing.plaf.tsql.TSQLLookAndFeel;

public class MainFrame extends JFrame {
    JDesktopPane desktop;
    MainInternalFrame frame;

    public MainFrame() {
        super("InternalFrameDemo");
        try
        {
            UIManager.setLookAndFeel(new TSQLLookAndFeel());
        } // try
        catch(Exception e)
        {
            System.out.println(e.getMessage());
        } // catch(ClassNotFoundException cnfe)
        //Make the big window be indented 50 pixels from each edge 
        //of the screen.
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        //setBounds(inset, inset, 
        //          screenSize.width - inset*2, 
        //          screenSize.height-inset*2);
        setBounds(0, 0, 
                  screenSize.width, 
                  screenSize.height- 40);

        //Quit this app when the big window closes.
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                exitApplication();
            }
        });

        //Set up the GUI.
        desktop = new JDesktopPane(); //a specialized layered pane
        createFrame(); //Create first window
        setContentPane(desktop);
        setJMenuBar(createMenuBar());

        //Make dragging faster:
        desktop.putClientProperty("JDesktopPane.dragMode", "outline");
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();

        /*
        JMenu menu = new JMenu("Document");
        menu.setMnemonic(KeyEvent.VK_D);
        JMenuItem menuItem = new JMenuItem("New");
        menuItem.setMnemonic(KeyEvent.VK_N);
        menuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                createFrame();
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
         */
        // creating the file menu
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(KeyEvent.VK_F);
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.setMnemonic(KeyEvent.VK_X);

        exitMenuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                exitApplication();
            }
        });
        fileMenu.add(exitMenuItem);
        
        // creating the view menu
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(KeyEvent.VK_V);
        JMenuItem viewMainInternalFrameMenuItem = new JMenuItem("Show window");
        //viewMainInternalFrameMenuItem.setMnemonic(KeyEvent.VK_X);

        viewMainInternalFrameMenuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                viewMainInternalFrame();
            }
        });
        viewMenu.add(viewMainInternalFrameMenuItem);
        
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        
        return menuBar;
    }
    
    protected void createFrame() {
        //MainInternalFrame frame = new MainInternalFrame();
        frame = new MainInternalFrame();
	frame.setVisible(true); //necessary as of kestrel
        desktop.add(frame);
        try {
            frame.setSelected(true);
        } catch (java.beans.PropertyVetoException e) {}
    }
    
    protected void viewMainInternalFrame() {
        frame.setVisible(true); //necessary as of kestrel
        // to make the same frame reappear
        desktop.remove(frame);
        desktop.add(frame);
        try {
            frame.setSelected(true);
        } catch (java.beans.PropertyVetoException e) {}
    }
           
    protected void exitApplication()
    {
        System.exit(0);
    } // protected void exitApplication()

    public static void main(String[] args) {
        MainFrame frame = new MainFrame();
        frame.setVisible(true);
    }
}
