# -*- coding: utf-8 -*-
import urllib,urllib2,ConfigParser,Queue,threading,functools,itertools
import xml.sax as sax
from xml.sax.handler import ContentHandler
import config
query_host = 'http://yp.shoutcast.com/'
query_url_base = query_host + 'sbin/newxml.phtml?'
limit_query = '&limit=%s'

mime_type = {'audio/mpeg':'MP3',
             'audio/aacp':'AAC+',
             'audio/aac':'AAC',
             'audio/ogg':'OGG',
             'audio/flac':'FLAC'}

class StationListHandler(ContentHandler):
    def __init__(self,callback):
        self.__callback = callback

    def startElement(self, name, attrs):
        if name == 'station':
            info = (attrs.getValue('mt'),
                    attrs.getValue('br'),
                    attrs.getValue('genre'),
                    attrs.getValue('lc'),
                    attrs.getValue('ct'))

            self.__callback(attrs.getValue('name'),
                            attrs.getValue('id'),
                            info)

class GenreListHandler(ContentHandler):
    def __init__(self,callback):
        self.__callback = callback

    def startElement(self, name, attrs):
        if name == 'genre':
            self.__callback(attrs.getValue('name'))

class LimitedHTTPRedirectHandler(object):
    def __init__(self,redirect=1):
        self.redirect = redirect
        self.handler = urllib2.HTTPRedirectHandler()
        self.redirect_func = self.handler.redirect_request
        self.handler.redirect_request = self.redirect_request

    @property
    def redirector(self):
        return self.handler

    def redirect_request(self,*args,**kwds):
        if self.redirect > 0:
            self.redirect -= 1
            return self.redirect_func(*args,**kwds)

class StationActivity(object):
    @staticmethod
    def is_active(url):
        is_active_station = False
        handler = LimitedHTTPRedirectHandler()
        opener = urllib2.build_opener(handler.redirector)
        urllib2.install_opener(opener)
        try:
            urllib2.urlopen(url).headers
            is_active_station = True
        except:
            pass
        
        return is_active_station

class _ThreadPool(threading.Thread):
    __need_terminate = False
    __pool = []
    __super = None
    def __init__(self,func_iter,max_count=5):
        self.max_count = max_count
        self.func_iter = func_iter
        self.__super = super(self.__class__,self)
        self.__super.__init__()

    def terminate(self):
        self.__need_terminate = True
        self.__super.join()

    def run(self):
        for func in self.func_iter:
            if self.__need_terminate:
                break
            while not self.__need_terminate:
                if len(self.__pool) == self.max_count:
                    for worker in self.__pool:
                        if not worker.isAlive():
                            self.__pool.remove(worker)
                    continue
                worker = threading.Thread(target=func)
                worker.start()
                self.__pool.append(worker)
        for worker in self.__pool: worker.join()

class PlayListParser:
    def __init__(self,fileobj):
        self.parser = ConfigParser.RawConfigParser()
        self.parser.readfp(fileobj)

    def get_active_item(self):
        q = Queue.Queue()
        def __validate_activity(url):
            if StationActivity.is_active(url):
                q.put_nowait(url)
        def func_wrapper(item):
            return functools.partial(\
                __validate_activity,url=item)

        self.pool = _ThreadPool(itertools.imap(func_wrapper,
                                               self.iteritems())
                                )
        self.pool.start()
        link = q.get()
        self.pool.terminate()
        return link

    def get_item(self,sec,index):
        return self.parser.get(sec,'File%d' % index)

    def iteritems(self):
        sec ='playlist'
        entry_sum = self.parser.getint(sec,'numberofentries')
        if entry_sum == 1:
            yield self.get_item(sec,entry_sum)
        else:
            for i in range(1,entry_sum):
                yield self.get_item(sec,i)
     
def get_opener():
    opener = urllib2.build_opener()
    opener.addheaders =[('User-Agent',
                         'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)')]
    return opener

def translate_info(*args):
    args = args[0]
    mime,bitrate,genre = args[0:3]
    format = mime_type.get(mime,mime)
    info = '[%s %skb] Genre: %s' % (format,
                                    bitrate,
                                    genre)
    if len(args) > 3:
        info += '\n[Listen: %s] Playing: %s' % args[3:]
    return info

def saxing_url_resource(url,handler):
    opener = get_opener()
    source = opener.open(url)
    saxing_data(source,handler)

def saxing_data(data,handler):
    parser = sax.make_parser()
    parser.setFeature(sax.handler.feature_namespaces, 0)
    parser.setContentHandler(handler)
    parser.parse(data)
    del data
    del parser

def get_playlist(id):
    opener = get_opener()
    return opener.open(query_host + 'sbin/tunein-station.pls?id=%s' % id)

def get_stations(callback,genre,
                 limit=config.request_limit):
    resource = query_get_stations(genre,limit)
    handler = StationListHandler(callback)
    saxing_data(resource,handler)

def query_get_stations(genre,
                       limit=config.request_limit):
    target = (query_url_base +'genre=%s'  + limit_query )% (genre,limit)
    return get_opener().open(target)

def search_stations(callback,search_text,bitrate,codec,
                    limit=config.request_limit):
    resource = query_search_stations(search_text,bitrate,codec,
                                     limit)

    handler = StationListHandler(callback)
    saxing_data(resource,handler)

def query_search_stations(search_text,bitrate,codec,
                          limit=config.request_limit):
    target = (query_url_base + \
                  'search=%s&bitrate=%s&mt=%s' + limit_query) \
                  % (urllib.quote(search_text),bitrate,codec,limit)
    return get_opener().open(target)

if __name__ == '__main__':
    genre_list_url = 'http://www.shoutcast.com/sbin/newxml.phtml'
    from cStringIO import StringIO
    result = StringIO()
    callback = lambda name:result.write('"%s",' % name)
    handler = GenreListHandler(callback)
    saxing_url_resource(genre_list_url,handler)
    print '[' + result.getvalue().strip(',') + ']'
    result.close()
