﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

''' <summary>保存された検索を表します。</summary>
<DebuggerDisplay("Search {Query}")>
Public Class SavedSearch
    Implements ITwitterIdData

    Friend Sub New()
    End Sub

    ''' <summary>取得したXMLから情報を読み取ります。</summary>
    Protected Overridable Sub LoadAll(ByVal doc As XElement)
        On Error Resume Next
        _id = Long.Parse(doc.<id>.Value)
        _query = doc.<query>.Value
        created_at = Date.SpecifyKind(Date.ParseExact(doc.<created_at>.Value, "ddd MMM dd HH:mm:ss +0000 yyyy", New Globalization.CultureInfo("en-US")), DateTimeKind.Utc)
    End Sub

    ''' <summary>XMLから新しいインスタンスを作成します。</summary>
    Public Shared Function FromXml(ByVal doc As XElement) As SavedSearch
        Dim re As New SavedSearch
        re.LoadAll(doc)
        Return re
    End Function

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend created_at As Date
    ''' <summary>保存日時</summary>
    Public ReadOnly Property CreatedAt As Date Implements ITwitterIdData.CreatedAt
        Get
            Return created_at.ToLocalTime()
        End Get
    End Property
    ''' <summary>保存日時（UTC）</summary>
    Public ReadOnly Property CreatedAtUtc As Date Implements ITwitterIdData.CreatedAtUtc
        Get
            Return created_at
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend _id As Long
    ''' <summary>ID</summary>
    Public ReadOnly Property Id As Long Implements ITwitterIdData.Id
        Get
            Return _id
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> Protected Friend _query As String
    ''' <summary>検索内容</summary>
    Public ReadOnly Property Query As String
        Get
            Return _query
        End Get
    End Property

    ''' <summary>常にIdObjectType.SavedSearchを返します。</summary>
    Private ReadOnly Property ObjectType As IdObjectType Implements ITwitterIdData.ObjectType
        Get
            Return IdObjectType.SavedSearch
        End Get
    End Property
End Class
