﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Imports <xmlns="http://www.w3.org/2005/Atom">
Imports <xmlns:twitter="http://api.twitter.com/">
Namespace TwitterServices
    ''' <summary>ステータスを操作します。</summary>
    Public NotInheritable Class StatusesService
        Friend Sub New(ByVal tw As Twitter)
            Me.tw = tw
        End Sub
        <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
        Dim tw As Twitter

        ''' <summary>指定したつぶやきを取得します。</summary>
        ''' <param name="id">ステータスID</param>
        Public Function GetStatus(ByVal id As Long) As TwitterStatus
            Dim param As New Dictionary(Of String, String)
            param.Add("id", id.ToString)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "statuses/show.xml"), "GET", param, Nothing)

            Dim doc = XElement.Load(stream)
            stream.Close()
            Return TwitterStatus.FromXml(doc)
        End Function

        ''' <summary>つぶやきを投稿します。</summary>
        ''' <param name="status">つぶやく内容</param>
        ''' <returns>投稿したつぶやき</returns>
        Public Overloads Function Update(ByVal status As String) As TwitterStatus
            Dim param As New Dictionary(Of String, String)
            param.Add("status", status)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "statuses/update.xml"), "POST", param, Nothing)
            Dim xd = XElement.Load(stream)
            stream.Close()
            Return TwitterStatus.FromXml(xd)
        End Function
        ''' <summary>つぶやきを投稿します。</summary>
        ''' <param name="status">つぶやく内容</param>
        ''' <param name="in_reply_to_status_id">返信先のステータスID</param>
        ''' <returns>投稿したつぶやき</returns>
        Public Overloads Function Update(ByVal status As String, ByVal in_reply_to_status_id As Long) As TwitterStatus
            Dim param As New Dictionary(Of String, String)
            param.Add("status", status)
            param.Add("in_reply_to_status_id", in_reply_to_status_id.ToString)
            Dim stream = tw.GetStream(Twitter.CreateUri(1, "statuses/update.xml"), "POST", param, Nothing)
            Dim xd = XElement.Load(stream)
            stream.Close()
            Return TwitterStatus.FromXml(xd)
        End Function

        ''' <summary>つぶやきを削除します。</summary>
        ''' <param name="statusid">削除するステータスID</param>
        Public Overloads Sub Destroy(ByVal statusid As Long)
            Dim uri = Twitter.CreateUri(1, String.Format("statuses/destroy/{0}.xml", statusid))
            tw.GetStream(uri, "POST", Nothing, Nothing).Close()
        End Sub

        ''' <summary>リツイートします。</summary>
        ''' <param name="statusid">リツイートするステータスID</param>
        ''' <returns>リツイート結果</returns>
        Public Overloads Function Retweet(ByVal statusid As Long) As TwitterStatus
            Dim stream = tw.GetStream(Twitter.CreateUri(1, String.Format("statuses/retweet/{0}.xml", statusid)), "POST", Nothing, Nothing)
            Dim doc = XElement.Load(stream)
            stream.Close()
            Return TwitterStatus.FromXml(doc)
        End Function

        Private Overloads Function Search(ByVal stream As Stream, ByVal close As Boolean) As IEnumerable(Of TwitterStatus)
            'Dim sr As New StreamReader(stream)
            'Dim str = sr.ReadToEnd
            Dim doc = XElement.Load(stream)
            If close Then stream.Close()
            Dim re As New List(Of TwitterStatus)
            For Each node In doc.<entry>
                Dim ts As New TwitterStatus
                Dim href = node.<link>.Where(Function(o) o.@rel = "alternate")(0).@href
                ts._id = Long.Parse(href.Substring(href.LastIndexOf("/"c) + 1))
                ts.created_at = Date.ParseExact(node.<updated>.Value, "yyyy-MM-ddTHH:mm:ssZ", New Globalization.CultureInfo("en-US"))
                ts._text = node.<title>.Value
                ts._source = New TweetSource(node.<twitter:source>.Value)
                Dim tu As New TwitterUser
                Dim author = node.<author>.<name>.Value
                tu._screenname = author.Substring(0, author.IndexOf(" "c))
                Dim name_start = author.IndexOf("("c) + 1
                tu._name = author.Substring(name_start, author.LastIndexOf(")"c) - name_start)
                tu.profile_image_url = New Uri(node.<link>.Where(Function(o) o.@rel = "image")(0).@href)
                ts._user = tu
                re.Add(ts)
            Next node
            Return re
        End Function
        ''' <summary>つぶやきを検索します。</summary>
        ''' <param name="q">検索内容</param>
        ''' <param name="lang">言語</param>
        ''' <param name="rpp">1ページに返される個数 1～100</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function Search(ByVal q As String, ByVal lang As String, ByVal rpp As Integer, ByVal page As Integer) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("q", q)
            param.Add("lang", lang)
            param.Add("rpp", rpp.ToString)
            param.Add("page", page.ToString)
            Dim stream = tw.GetStream(New Uri("https://search.twitter.com/search.atom"), "GET", param, Nothing)
            Return Search(stream, True)
        End Function
        ''' <summary>つぶやきを検索します。</summary>
        ''' <param name="q">検索内容</param>
        Public Overloads Function Search(ByVal q As String) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("q", q)
            Dim stream = tw.GetStream(New Uri("https://search.twitter.com/search.atom"), "GET", param, Nothing)
            Return Search(stream, True)
        End Function
        ''' <summary>つぶやきを検索します。</summary>
        ''' <param name="q">検索内容</param>
        ''' <param name="lang">言語</param>
        Public Overloads Function Search(ByVal q As String, ByVal lang As String) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("q", q)
            param.Add("lang", lang)
            Dim stream = tw.GetStream(New Uri("https://search.twitter.com/search.atom"), "GET", param, Nothing)
            Return Search(stream, True)
        End Function
        ''' <summary>つぶやきを検索します。</summary>
        ''' <param name="q">検索内容</param>
        ''' <param name="rpp">1ページに返される個数 1～100</param>
        ''' <param name="page">ページ番号 1～</param>
        Public Overloads Function Search(ByVal q As String, ByVal rpp As Integer, ByVal page As Integer) As IEnumerable(Of TwitterStatus)
            Dim param As New Dictionary(Of String, String)
            param.Add("q", q)
            param.Add("rpp", rpp.ToString)
            param.Add("page", page.ToString)
            Dim stream = tw.GetStream(New Uri("https://search.twitter.com/search.atom"), "GET", param, Nothing)
            Return Search(stream, True)
        End Function
    End Class
End Namespace