﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

''' <summary>Twitterと通信中に発生したプロトコルエラー</summary>
Public NotInheritable Class TwitterException
    Inherits Exception

    Private Sub New(ByVal message As String, ByVal statuscode As HttpStatusCode, ByVal innerex As Exception)
        MyBase.New(message, innerex)
        _statuscode = statuscode
    End Sub

    Friend Shared Function GetNewTwitterException(ByVal ex As WebException) As TwitterException
        'エラーメッセージを取得
        Dim message As String
        Dim res = DirectCast(ex.Response, HttpWebResponse)
        Try
            Dim xd = XElement.Load(res.GetResponseStream)
            message = xd.<error>.Value
        Catch
            message = String.Format("エラーの詳細を取得できませんでした：{0} {1}", CInt(res.StatusCode), res.StatusCode.ToString)
        End Try

        Return New TwitterException(message, res.StatusCode, ex)
    End Function

    Dim _statuscode As HttpStatusCode
    Public ReadOnly Property StatusCode As HttpStatusCode
        Get
            Return _statuscode
        End Get
    End Property
End Class