﻿'Copyright (C) 2010 pepetaro, All rights reserved.
'This library is free software; you can redistribute it and/or
'modify it under the terms of the GNU Lesser General Public
'License as published by the Free Software Foundation; either
'version 3 of the License, or (at your option) any later version.

'This library is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'Lesser General Public License for more details.

'You should have received a copy of the GNU Lesser General Public
'License along with this library; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

''' <summary>Twitterのつぶやきを表します。</summary>
<DebuggerDisplay("Status {Text}")> _
Public Class TwitterStatus
    Implements ITwitterIdData, IComparable, IComparable(Of TwitterStatus), IEquatable(Of TwitterStatus)

    Friend Sub New()
    End Sub

    ''' <summary>取得したXMLから情報を読み取ります。</summary>
    Protected Overridable Sub LoadAll(ByVal doc As XElement)
        On Error Resume Next
        created_at = Date.SpecifyKind(Date.ParseExact(doc.<created_at>.Value, "ddd MMM dd HH:mm:ss +0000 yyyy", New Globalization.CultureInfo("en-US")), DateTimeKind.Utc)
        _id = Long.Parse(doc.<id>.Value)
        _text = doc.<text>.Value
        _source = New TweetSource(doc.<source>.Value)
        in_reply_to_status_id = Long.Parse(doc.<in_reply_to_status_id>.Value)
        in_reply_to_user_id = Long.Parse(doc.<in_reply_to_user_id>.Value)
        in_reply_to_screen_name = doc.<in_reply_to_screen_name>.Value
        _user = TwitterUser.FromXml(doc.<user>(0))
        retweeted_status = FromXml(doc.<retweeted_status>(0))
    End Sub

    ''' <summary>XMLから新しいインスタンスを作成します。</summary>
    Public Shared Function FromXml(ByVal doc As XElement) As TwitterStatus
        Dim re As New TwitterStatus
        re.LoadAll(doc)
        If re.Id = 0 Then
            Return Nothing
        Else
            Return re
        End If
    End Function

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend created_at As Date
    ''' <summary>取得日時（UTC）</summary>
    Public ReadOnly Property CreatedAtUtc As Date Implements ITwitterIdData.CreatedAtUtc
        Get
            Return created_at
        End Get
    End Property

    ''' <summary>取得日時</summary>
    Public ReadOnly Property CreatedAt As Date Implements ITwitterIdData.CreatedAt
        Get
            Return created_at.ToLocalTime
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend _id As Long
    ''' <summary>ステータスID</summary>
    Public ReadOnly Property Id As Long Implements ITwitterIdData.Id
        Get
            Return _id
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend _text As String
    ''' <summary>つぶやき内容</summary>
    Public ReadOnly Property Text As String
        Get
            Return _text
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend _source As TweetSource
    ''' <summary>投稿に使ったクライアント</summary>
    Public ReadOnly Property Source As TweetSource
        Get
            Return _source
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend in_reply_to_status_id As Long
    ''' <summary>返信先のステータスID</summary>
    Public ReadOnly Property InReplyToStatusId As Long
        Get
            Return in_reply_to_status_id
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend in_reply_to_user_id As Long
    ''' <summary>返信先ユーザーのID</summary>
    Public ReadOnly Property InReplyToUserId As Long
        Get
            Return in_reply_to_user_id
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend in_reply_to_screen_name As String
    ''' <summary>返信先ユーザーの表示名（@○○）</summary>
    Public ReadOnly Property InReplyToScreenName As String
        Get
            Return in_reply_to_screen_name
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend _user As TwitterUser
    ''' <summary>投稿者</summary>
    Public ReadOnly Property User As TwitterUser
        Get
            Return _user
        End Get
    End Property

    <DebuggerBrowsable(DebuggerBrowsableState.Never)> _
    Protected Friend retweeted_status As TwitterStatus
    ''' <summary>リツイートしたつぶやき</summary>
    Public ReadOnly Property RetweetedStatus As TwitterStatus
        Get
            Return retweeted_status
        End Get
    End Property

    ''' <summary>常にIdObjectType.Statusを返します。</summary>
    Private ReadOnly Property ObjectType As IdObjectType Implements ITwitterIdData.ObjectType
        Get
            Return IdObjectType.Status
        End Get
    End Property

    Public Overrides Function ToString() As String
        Return _text
    End Function

    Public Overloads Function CompareTo(ByVal obj As Object) As Integer Implements System.IComparable.CompareTo
        Dim o = DirectCast(obj, TwitterStatus)
        Return _id.CompareTo(obj)
    End Function
    Public Overloads Function CompareTo(ByVal other As TwitterStatus) As Integer Implements System.IComparable(Of TwitterStatus).CompareTo
        Return _id.CompareTo(other)
    End Function

    Public Overloads Function Equals(ByVal other As TwitterStatus) As Boolean Implements System.IEquatable(Of TwitterStatus).Equals
        Return Me = other
    End Function

    Public Shared Operator =(ByVal ts1 As TwitterStatus, ByVal ts2 As TwitterStatus) As Boolean
        Return ts1._id = ts2._id
    End Operator
    Public Shared Operator <>(ByVal ts1 As TwitterStatus, ByVal ts2 As TwitterStatus) As Boolean
        Return ts1._id <> ts2._id
    End Operator
    Public Shared Operator <(ByVal ts1 As TwitterStatus, ByVal ts2 As TwitterStatus) As Boolean
        Return ts1._id < ts2._id
    End Operator
    Public Shared Operator >(ByVal ts1 As TwitterStatus, ByVal ts2 As TwitterStatus) As Boolean
        Return ts1._id > ts2._id
    End Operator
    Public Shared Operator <=(ByVal ts1 As TwitterStatus, ByVal ts2 As TwitterStatus) As Boolean
        Return ts1._id <= ts2._id
    End Operator
    Public Shared Operator >=(ByVal ts1 As TwitterStatus, ByVal ts2 As TwitterStatus) As Boolean
        Return ts1._id >= ts2._id
    End Operator
End Class
