//  PPrefFastTrack.m
// -------------------------------------------------------------------------
// Copyright (C) 2003 Poisoned Project (http://www.gottsilla.net/)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------


#import "PPrefFastTrack.h"
#import "PFastTrackConf.h"

#define userDefaults [NSUserDefaults standardUserDefaults]

@implementation PPrefFastTrack
- (void)awakeFromNib
{
    [self readConfFiles];
     
    // NSUserDefaults * userDefaults;
    //userDefaults = [NSUserDefaults standarduserDefaults];
     
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(readConfFiles) name:@"PUpdateFromConfFiles" object:nil];
    
    //if ([userDefaults boolForKey:@"PAutoFMS"]) [enableAFMS setState:NSOnState];
    //else [enableAFMS setState:NSOffState];

}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}


- (void)enable
{
    [alias setEnabled:YES];
}

- (void)disable
{
    [alias setEnabled:NO];
}

- (void)readConfFiles
{
    if (fasttrack_conf=[PFastTrackConf singleton]) [self enable];
    else {
        [self disable];
        return;
    }
    
    [fasttrack_conf read];
    
    [alias setStringValue:[fasttrack_conf optionForKey:@"alias"]];
    [port setIntValue:[[fasttrack_conf optionForKey:@"port"]intValue]];
    [forwardPort setIntValue:[[fasttrack_conf optionForKey:@"forwarding"]intValue]];
    [enableBanList setIntValue:[[fasttrack_conf optionForKey:@"banlist_filter"]intValue]];
    [enableSharing setIntValue:[[fasttrack_conf optionForKey:@"allow_sharing"]intValue]];
}

- (IBAction)newAlias:(id)sender
{
	// whitespace in user names causes problems
	// set to remove space, possible other whitespace characters can cause problems don't know yet
	// /t and /r are also considered whitespace but the input feilds don't accept those
	NSMutableString* nameString = [NSMutableString stringWithFormat:[sender stringValue]];
	NSRange entireString = NSMakeRange (0, [nameString length]);
	[nameString replaceOccurrencesOfString:@" " withString:@"_" options:NSLiteralSearch range:entireString];
    [fasttrack_conf setValue:nameString forKey:@"alias"];
    [self readConfFiles];
}

- (IBAction)newPort:(id)sender
{
    [fasttrack_conf setValue:[NSNumber numberWithInt:[sender intValue]] forKey:@"port"];
    [self readConfFiles];
}
- (IBAction)portForwardChanged:(id)sender
{
    [fasttrack_conf setValue:[NSNumber numberWithInt:[sender intValue]] forKey:@"forwarding"];

    [self readConfFiles]; 
}
- (IBAction)banListChanged:(id)sender
{
    [fasttrack_conf setValue:[NSNumber numberWithInt:[sender intValue]] forKey:@"banlist_filter"];

    [self readConfFiles];  
}

- (IBAction)sharingChanged:(id)sender
{
    [fasttrack_conf setValue:[NSNumber numberWithInt:[sender intValue]] forKey:@"allow_sharing"];

    [self readConfFiles];  
}
/*
- (IBAction)autoFindMoreSourcesChanged:(id)sender
{

    if ([enableAFMS state]==NSOnState) [userDefaults setBool:YES forKey:@"PAutoFMS"];
    else [userDefaults setBool:NO forKey:@"PAutoFMS"];

}
*/

@end
