//  PPrefGnutella.m
// -------------------------------------------------------------------------
// Copyright (C) 2003 Poisoned Project (http://www.gottsilla.net/)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------

#import "PPrefGnutella.h"

@implementation PPrefGnutella

- (void)awakeFromNib
{
    [self readConfFiles];
     
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(readConfFiles) name:@"PUpdateFromConfFiles" object:nil];

}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}


- (void)enable
{
        [port setEnabled:YES];
        [proxy setEnabled:YES];
}

- (void)disable
{
        [port setEnabled:NO];
        [proxy setEnabled:NO];
}

- (void)readConfFiles
{
    if (gnutella_conf=[PGnutellaConf singleton]) [self enable];
    else {
        [self disable];
        return;
    }
    
    [gnutella_conf read];
        
    [port setIntValue:[[gnutella_conf optionForKey:@"port"] intValue]];
    [proxy setStringValue:[gnutella_conf optionForKey:@"proxy"]];
}

- (IBAction)newPort:(id)sender
{
    [gnutella_conf setValue:[NSNumber numberWithInt:[sender intValue]] forKey:@"port"];
    [self readConfFiles];
}

- (IBAction)newProxy:(id)sender
{
    [gnutella_conf setValue:[sender stringValue] forKey:@"proxy"];
    [self readConfFiles];
}

@end
