// PPrefiTunes.m
// -------------------------------------------------------------------------
// Copyright (C) 2003 Poisoned Project (http://www.gottsilla.net/)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// ---------------------------------------------------------------------------


#import "PPrefiTunes.h"

#define userDefaults [NSUserDefaults standardUserDefaults]

@implementation PPrefiTunes

- (void)awakeFromNib
{
    [self loadDefaults];
}

/* Register Defaults */

- (void) registerDefaults; 
{
	id dict = [[[NSMutableDictionary alloc] init] autorelease];
    
	[dict setObject: @"1"		forKey: @"PAddSong"];
	[dict setObject: @"1"		forKey: @"PAddSongToPlaylist"];
	[dict setObject: @"0"		forKey: @"PPlaySong"];
	[dict setObject: @"0"		forKey: @"PDeleteAfterImport"];
	[dict setObject: @"Poisoned"forKey: @"PImportPlaylistName"];
            
	[userDefaults registerDefaults: dict];
}


/* Load Defaults */

- (void) loadDefaults; 
{
	/* Add Song */
        
	tempBool = [userDefaults boolForKey: @"PAddSong"];
	[addSong setState: (tempBool) ? NSOnState : NSOffState];

	[addSongToPlaylist setEnabled: tempBool];
	[playSong setEnabled: tempBool];
	[deleteAfterImport setEnabled: tempBool];
	[importPlaylistName setEnabled: tempBool];

	/* Add Song to Playlist */
        
	tempBool = [userDefaults boolForKey: @"PAddSongToPlaylist"];
	[addSongToPlaylist setState: (tempBool) ? NSOnState : NSOffState];

	/* Play Song */
            
	tempInt = [userDefaults integerForKey: @"PPlaySong"];
	[playSong selectCellAtRow: tempInt column: 0];
		
	/* Delete After Import */
            
	tempBool = [userDefaults boolForKey: @"PDeleteAfterImport"];
	[deleteAfterImport setState: (tempBool) ? NSOnState : NSOffState];
            
	/* Import playlist name */
	[importPlaylistName setStringValue:[userDefaults objectForKey:@"PImportPlaylistName"]];
}


/* Mutate Defaults */

- (void) addSong: (id) sender; 
{
	tempBool = [sender intValue];
	[userDefaults setBool: tempBool forKey: @"PAddSong"];
	[self loadDefaults];
}
    
- (void) addSongToPlayList: (id) sender; {
	tempBool = [sender intValue];
	[userDefaults setBool: tempBool forKey: @"PAddSongToPlaylist"];
	[self loadDefaults];
}

- (void) playSong: (id) sender; {
	[userDefaults setInteger: [sender selectedRow] forKey: @"PPlaySong"];
	[self loadDefaults];
}

- (void) deleteAfterImport: (id) sender; {
	tempBool = [sender intValue];
	[userDefaults setBool: tempBool forKey: @"PDeleteAfterImport"];
	[self loadDefaults];
}
    
- (IBAction) importPlaylistNameChanged:(id)sender; {
	[userDefaults setObject: [sender stringValue] forKey:@"PImportPlaylistName"];
	[self loadDefaults];
}

@end