<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: Student.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/20
//

require_once (OPT_DIR.'u-learning/data/DataObject.class.php');
require_once (OPT_DIR.'u-learning/data/SubjectStudent.class.php');
require_once (OPT_DIR.'u-learning/data/StudentExam.class.php');

/**
 * Student
 * 
 * 学生クラス
 */
class Student extends DataObject {

    // 学生ID
    var $uid;

    // 教員ID
    var $aid;
    // パスワード
    var $pass;
    // 氏名
    var $name;
    // メールアドレス
    var $mail;
    // 学生番号
    var $number;
    // 学年
    var $year;
    // 登録フラグ
    var $regist;
    // 削除フラグ
    var $del;

    // 科目
    var $subjects;

    /**
     * コンストラクタ
     */
    function Student($aid= null, $uid= null, $db= null) {
        if (!is_null($aid) && !is_null($uid) && !is_null($db)) {
            $this->setDB($db);
            $this->aid= $aid;
            $this->uid= $uid;

            $sql= "SELECT * FROM user_info WHERE aid = ".$this->DB->qstr($aid)." and uid = ".$this->DB->qstr($uid);
            $row= $this->DB->GetRow($sql);
            if (count($row) > 0) {
                $this->setValues($row);
            }
        }
    }

    /**
     * 値をセット
     */
    function setValues($array) {
        $this->uid= $array['uid'];
        $this->aid= $array['aid'];
        $this->pass= $array['pass'];
        $this->name= $array['name'];
        $this->mail= $array['mail'];
        $this->number= $array['number'];
        $this->year= $array['year'];
        $this->regist= $array['regist'];
        $this->del= $array['del'];
    }

    /**
     * 更新
     */
    function update($db= null) {
        $this->setDB($db);
        $sql= "update user_info SET "."pass = ".$this->DB->qstr($this->pass).", "."name = ".$this->DB->qstr($this->name).", "."mail = ".$this->DB->qstr($this->mail).", "."number = ".$this->DB->qstr($this->number).", "."year = ".$this->DB->qstr($this->year).", "."regist = ".$this->DB->qstr($this->regist).", "."del = ".$this->DB->qstr($this->del)." WHERE aid = ".$this->DB->qstr($this->aid)." and uid = ".$this->DB->qstr($this->uid);
        return $this->DB->Execute($sql);
    }

    /**
     * 追加
     */
    function insert($db= null) {
        $this->setDB($db);
        $sql= "insert into user_info (aid, uid, pass, mail, name, number, year) values (".$this->DB->qstr($this->aid).", ".$this->DB->qstr($this->uid).", ".$this->DB->qstr($this->pass).", ".$this->DB->qstr($this->mail).", ".$this->DB->qstr($this->name).", ".$this->DB->qstr($this->number).", ".$this->DB->qstr($this->year).") ";

        return $this->DB->Execute($sql);
    }

    /**
     * 科目一覧を取得
     */
    function getSubjectStudent($db= null) {
        $this->setDB($db);
        $sql= "select u.aid, u.uid, u.sid, a.name from user_subject u, admin_subject a "." where u.aid = ".$this->DB->qstr($this->aid)." and u.uid = ".$this->DB->qstr($this->uid)." and u.aid = a.aid  and u.sid = a.sid and a.del <> '1'";
        $all= $this->DB->GetAll($sql);
        $this->subjects= array ();
        foreach ($all as $row) {
            $subject= new SubjectStudent();
            $subject->setValues($row);
            array_push($this->subjects, $subject);
        }
        return $this->subjects;

    }

    /**
     * 選択したテストの回答一覧を取得
     */
    function getExamsStudentByExam($eid, $db= null) {
        $this->setDB($db);
        $sql= "SELECT * FROM user_exam "." WHERE eid = ".$this->DB->qstr($eid)." and aid = ".$this->DB->qstr($this->aid)." and uid = ".$this->DB->qstr($this->uid)." and reply_date is not null order by rid, reply_date ";
        $all= $this->DB->GetAll($sql);
        $this->exams_student= array ();
        foreach ($all as $row) {
            $student_exam= new StudentExam();
            $student_exam->setExamValues($row);
            array_push($this->exams_student, $student_exam);
        }
        return $this->exams_student;

    }

    /**
     * 選択した科目のテスト回答一覧を全て取得
     */
    function getExamsStudentBySubject($sid, $db= null) {
        $this->setDB($db);
        $sql= "select u.* from user_exam u, admin_exam a "." where a.sid = ".$this->DB->qstr($sid)." and u.aid = ".$this->DB->qstr($this->aid)." and u.uid = ".$this->DB->qstr($this->uid)." and u.eid = a.eid "." order by rid, reply_date ";
        $all= $this->DB->GetAll($sql);
        $this->exams_student= array ();
        foreach ($all as $row) {
            $student_exam= new StudentExam();
            $student_exam->setExamValues($row);
            array_push($this->exams_student, $student_exam);
        }
        return $this->exams_student;

    }

    /**
     * 受講している科目をセットする
     */
    function setSubjects() {
        $sql= "SELECT asub.* FROM"." user_subject usub INNER JOIN admin_subject asub USING(sid)"." WHERE asub.del <> '1' AND usub.aid = ".$this->DB->qstr($this->aid)." AND usub.uid = ".$this->DB->qstr($this->uid);
        $all= $this->DB->GetAll($sql);
        $this->subjects= array ();
        foreach ($all as $row) {
            $sub= new Subject();
            $sub->setValues($row);
            $sub->setDB($this->DB);
            array_push($this->subjects, $sub);
        }
        return $this->subjects;
    }

}
?>