<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: StudentExamDetail.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/30
//

require_once (OPT_DIR.'u-learning/data/StudentExam.class.php');
require_once (OPT_DIR.'u-learning/data/StudentQuestionDetail.class.php');

/**
 * StudentExamDetail
 * 
 * 学生テスト結果詳細
 */
class StudentExamDetail extends StudentExam {

    // 学生氏名
    var $uname;
    // 学年
    var $uyear;
    // 学生番号
    var $unumber;
    // 科目名
    var $sname;
    // テスト名
    var $ename;
    // 配信日
    var $publish_time;
    // 締切日
    var $deadline_time;

    /**
     * コンストラクタ
     */
    function StudentExamDetail($rid= null, $db= null) {
        if (!is_null($rid) && !is_null($db)) {
            $this->setDB($db);
            $this->rid= $rid;
            $select= "SELECT ue.aid, ue.uid,"." asub.sid, asub.name sname,"." ue.rid, ue.eid, ue.reply_date, ue.points,"." ae.name ename, ae.update_time, ae.retry, ae.correct, ae.share, ae.pub, ae.publish_time, ae.summary, ae.deadline_time,"." ui.pass, ui.name uname, ui.mail, ui.number unumber, ui.year uyear, ui.regist, ui.del";
            $from= "FROM ( ( ( user_exam ue LEFT JOIN user_subject usub ON ue.aid = usub.aid AND ue.uid = usub.uid )"." LEFT JOIN admin_exam ae ON ue.eid = ae.eid )"." LEFT JOIN admin_subject asub ON ae.sid = asub.sid )"." LEFT JOIN user_info ui ON usub.aid = ui.aid AND ue.uid = ui.uid";
            $where= "WHERE ue.rid = ".$rid." AND ui.regist = '1'";
            $group= "GROUP BY ue.rid";
            $row= $this->DB->GetRow("$select $from $where $group");
            if (count($row) > 0) {
                $this->setValues($row);
            }
        }
    }

    /**
     * 配列から値をセットする
     */
    function setValues($array) {
        $this->rid= $array['rid'];
        $this->aid= $array['aid'];
        $this->uid= $array['uid'];
        $this->eid= $array['eid'];
        $this->reply_date= $array['reply_date'];
        $this->points= $array['points'];

        if (array_key_exists('uname', $array))
            $this->uname= $array['uname'];
        if (array_key_exists('uyear', $array))
            $this->uyear= $array['uyear'];
        if (array_key_exists('unumber', $array))
            $this->unumber= $array['unumber'];
        if (array_key_exists('sname', $array))
            $this->sname= $array['sname'];
        if (array_key_exists('ename', $array))
            $this->ename= $array['ename'];
        if (array_key_exists('publish_time', $array))
            $this->publish_time= $array['publish_time'];
        if (array_key_exists('deadline_time', $array))
            $this->deadline_time= $array['deadline_time'];
    }

    /**
     * 設問のリストをセットする
     */
    function setQuestions() {
        $select= "SELECT uq.*, aq.number, aq.question, aq.explanation";
        $from= "FROM user_question uq INNER JOIN admin_question aq ON uq.qid = aq.qid ";
        $where= "WHERE uq.rid = ".$this->rid;
        $order= "ORDER BY aq.number";
        $all= $this->DB->GetAll("$select $from $where $order");
        $this->questions= array ();
        foreach ($all as $row) {
            $question= new StudentQuestionDetail();
            $question->setValues($row);
            $question->setDB($this->DB);
            $question->setChoice();
            // array_push($this->questions, $question);
            // array_push ではなく番号をキーにする
            $this->questions[$question->number]= $question;
        }
        return $this->questions;
    }

    /**
     * 設問番号を指定して設問結果を取得する
     */
    function getQuestionByNumber($n) {
        if (!is_array($this->questions))
            $this->setQuestions();
        foreach ($this->questions as $question) {
            if ($question->number == $n) {
                return $question;
            }
        }
    }
}
?>