<?php


// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: DBHandler.class.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/20
//

require_once (ADODB_DIR.'adodb.inc.php');

/**
 * DBHandler
 * 
 * ADODBのラッパークラス
 * 
 * 
 */
class DBHandler {

    // Logger
    var $deflog;

    // ADOConnection
    var $DB;

    /**
     * コンストラクタ
     */
    function DBHandler() {
        // Loggerのセット
        $this->deflog = & LogManager :: getLogger();

        //ADOdbの設定
        $GLOBALS["ADODB_CACHE_DIR"] = ADODB_CACHE_DIR;

        $DB = NewADOConnection(SQL_TYPE);
        $DB->debug = ADODB_DEBUG; //デバッグ設定
        $DB->cacheSecs = ADODB_CACHE_SECS; //キャッシュ有効時間

        //接続
        $ok = $DB->Connect(SQL_SERVER, SQL_USER, SQL_PASSWORD, SQL_DATABASE);

        if (!$ok) {
            //エラーが発生した場合、停止
            $this->outputLog('データベースに接続できませんでした。', 'fatal');
            return FALSE;
        }

        // 接続を保管
        $this->DB = & $DB;
    }

    function Execute($sql) {
        $sql = $this->db_encode($sql);
        $this->outputLog("SQL : ".$sql);
        return $this->DB->Execute($sql);
    }

    function & GetAll($sql, $cache = false) {
        $sql = $this->db_encode($sql);
        $this->outputLog("SQL : ".$sql);
        if ($cache) {
            $result = & $this->DB->CacheGetAll($sql);
        } else {
            $result = & $this->DB->GetAll($sql);
        }
        $this->detectError();
        return $this->http_encode($result);
    }

    function & GetRow($sql, $cache = false) {
        $sql = $this->db_encode($sql);
        $this->outputLog("SQL : ".$sql);
        if ($cache) {
            $result = & $this->DB->CacheGetRow($sql);
        } else {
            $result = & $this->DB->GetRow($sql);
        }
        $this->detectError();
        return $this->http_encode($result);
    }

    function & GetOne($sql, $cache = false) {
        $sql = $this->db_encode($sql);
        $this->outputLog("SQL : ".$sql);
        if ($cache) {
            $result = & $this->DB->CacheGetOne($sql);
        } else {
            $result = & $this->DB->GetOne($sql);
        }
        $this->detectError();
        return $this->http_encode($result);
    }

    function & GetArray($sql, $cache = false) {
        $sql = $this->db_encode($sql);
        $this->outputLog("SQL : ".$sql);
        if ($cache) {
            $result = & $this->DB->CacheGetArray($sql);
        } else {
            $result = & $this->DB->GetArray($sql);
        }
        $this->detectError();
        return $this->http_encode($result);
    }

    /**
     * ADODBのキャッシュを削除する
     */
    function & CacheFlush($sql = false, $inputarr = false) {
        return $this->DB->CacheFlush($sql, $inputarr);
    }

    /**
     * 文字列をクォート
     * シングルクォートも付加されることに注意
     */
    function & qstr($s, $magic_quotes = false) {
        return $this->DB->qstr($s, $magic_quotes);
    }

    /**
     * 文字列をDB用の文字コードに変換する
     */
    function & db_encode(& $value, $from = null) {
        if (is_null($from)) {
            mb_convert_variables(DB_ENCODING, "auto", $value);
        } else {
            mb_convert_variables(DB_ENCODING, $from, $value);
        }
        return $value;
    }

    /**
     * 引数の値をHTTP用の文字コードに変換する
     */
    function & http_encode(& $value, $from = null) {
        if (is_null($from)) {
            mb_convert_variables(HTTP_OUTPUT_ENCODING, "auto", $value);
        } else {
            mb_convert_variables(HTTP_OUTPUT_ENCODING, $from, $value);
        }
        return $value;
    }

    /**
     * 直前のINSERTで自動付与されたIDを取得する
     */
    function lastInsertID($table = '', $column = '') {
        $id = $this->DB->Insert_ID($table, $column);
        if ($id)
            return $id;
        $sql = "SELECT LAST_INSERT_ID()";
        return $this->DB->GetOne($sql);
    }

    /**
     * SQLに使用する日時の文字列を取得する
     */
    function DBTimeStamp($str) {
        return $this->DB->DBTimeStamp($str);
    }
    
    /**
     * エラーが発生していたら出力する
     */
    function detectError() {
        if($this->DB->ErrorNo()) {
            $this->outputLog("ERROR : ".$this->DB->ErrorMsg(), 'fatal');
        }
    }
    
    /**
     * ログを出力する
     */
    function outputLog($msg, $type = 'debug') {
        if($type == 'fatal') {
            error_log($type." : ".$msg);
            // print "エラーが発生しました！ : ".$type." : ".$msg;
        }
        $this->deflog->$type($msg);
    } 
}
?>