<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: ListAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');
require_once (BASE_DIR.'modules/Exam/config/list_config.php');

/**
 * ListAction
 * 
 * テスト一覧
 */
class ListAction extends AdminAction {

    /**
     * GET/POST
     */
    function execute(& $controller, & $request, & $user) {
        // DBコネクション
        $db= $request->getAttribute('DB');
        $admin= new Admin($user->getAttribute('aid'), $db);

        // テスト削除
        if ($del_id= $request->getParameter('del_eid')) {
            $admin->deleteExam($del_id);
            $this->location('Exam', 'List');
            return VIEW_NONE;
        }

        // 科目取得
        $subjects= $admin->getSubjects();
        $request->setAttribute('subjects', $subjects);

        // 未配信テスト取得
        $unpubs= $admin->getUnpubExams();
        $request->setAttribute('unpubs', $unpubs);

        // 配信済テスト取得
        $pubs= $admin->getPubExams(TOP_PUBLISHED_COUNT);
        $request->setAttribute('pubs', $pubs);

        // 配信済テストの最大数
        $max= $admin->getPubExamsCount();
        // 最大ページ数
        $max_page = ceil(($max -TOP_PUBLISHED_COUNT) / HISTORY_PUBLISHED_COUNT);
        $request->setAttribute('max_page', $max_page);
        
        $page = 0;
        $request->setAttribute('page', $page);
        
        $is_last= ($page == $max_page) ? true : false;
        $request->setAttribute('is_last', $is_last);

        return VIEW_SUCCESS;
    }

}
?>