<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: ListAction.class.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');
require_once (OPT_DIR.'u-learning/data/AdminExam.class.php');

/**
 * ListAction
 * 
 * 検索結果一覧
 */
class ListAction extends AdminAction {
    /**
     * GET/POST
     */
    function execute(& $controller, & $request, & $user) {
        $db= $request->getAttribute('DB');
        $admin= $request->getAttribute('admin');

        // 科目を取得
        $subjects= $admin->getSubjects($db);
        $request->setAttribute('subjects', $subjects);

        if ($request->hasParameter('sid') && $request->hasParameter('eid')) {
            $sid= $request->getParameter('sid');
            $eid= $request->getParameter('eid');

            // テストを取得
            $exam= new AdminExam($eid, $db);
            $request->setAttribute('exam', $exam);

            // 選択されている科目を取得
            $subject= null;
            foreach ($subjects as $sub) {
                if ($sub->sid == $sid) {
                    $subject= $sub;
                    $request->setAttribute('subject', $sub);
                }
            }

            // テスト結果詳細を取得
            $results= $subject->getStudentExamDetailByExam($eid);
            $request->setAttribute('results', $results);

        }
        elseif ($request->hasParameter('sid') && $request->hasParameter('uid')) {
            $sid= $request->getParameter('sid');
            $uid= $request->getParameter('uid');

            // 学生取得
            $student= new Student($admin->aid, $uid, $db);
            $request->setAttribute('student', $student);

            // テスト結果詳細を取得
            $results= $admin->getStudentExamDetailByUser($uid, $sid);
            $request->setAttribute('results', $results);
        }

        return VIEW_SUCCESS;
    }
}
?>