<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: SearchAction.class.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');
require_once (OPT_DIR.'u-learning/data/Subject.class.php');

/**
 * SearchAction
 * 
 * 成績検索
 */
class SearchAction extends AdminAction {

    /**
     * GET/POST
     */
    function execute(& $controller, & $request, & $user) {
        $db= $request->getAttribute('DB');
        $admin= new Admin($user->getAttribute('aid'), $db);

        // 科目を取得
        $subjects= $admin->getSubjects($db);
        /*
        foreach($subjects as $key => $subject) {
        	$subjects[$key]->setPubExams($db);
        	$subjects[$key]->setUsers($db);
        }
        */
        $request->setAttribute('subjects', $subjects);

        // 検索実行
        if ($request->hasParameter('s') && $request->hasParameter('g')) {
            $sid= $request->getParameter('s');
            $group= $request->getParameter('g');

            $request->setAttribute('sid', $sid);
            $request->setAttribute('group', $group);

            // 選択されている科目を取得
            foreach ($subjects as $subject) {
                if ($subject->sid == $sid) {
                    $request->setAttribute('subject', $subject);
                }
            }

            // 検索結果取得
            if ($group == 'exam') {
                $results= $admin->searchPubExams($sid);
            }
            elseif ($group == 'user') {
                $results= $admin->searchUsers($sid);
            }

            /*
                		$eid = $request->getParameter('e');
                		$uid = $request->getParameter('u');
                		$request->setAttribute('eid', $eid);
                		$request->setAttribute('uid', $uid);
            
                		$subject = new Subject($sid, $db);
                		if($group == 'exam') {
                			$exams = $subject->getExamResults($eid, $uid);
                			$request->setAttribute('results', $exams);
                		} elseif($group == 'user') {
                			$students = $subject->getStudentResults($eid, $uid);
                			$request->setAttribute('results', $students);
                		}
            */
            $request->setAttribute('results', $results);
        }

        return VIEW_SUCCESS;
    }
}
?>