<?php
// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: ExplanationEveryAction.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/18
//

/** 
*	ExplanationEveryAction.class.php
*	Mai Kawasaki
*	2005/05/18
*/
require_once(OPT_DIR.'u-learning/config.php');
require_once(OPT_DIR.'u-learning/action/SecureStudentAction.class.php');
require_once(OPT_DIR.'u-learning/data/Admin.class.php');
require_once(OPT_DIR.'u-learning/data/AdminExam.class.php');
require_once(OPT_DIR.'u-learning/data/AdminQuestion.class.php');
require_once(OPT_DIR.'u-learning/data/AdminChoice.class.php');
require_once(OPT_DIR.'u-learning/data/StudentExam.class.php');
require_once(OPT_DIR.'u-learning/data/StudentChoice.class.php');

/** 
*	ExplanationEveryAction
*/
class ExplanationEveryAction extends SecureStudentAction {
    function execute (&$controller, &$request, &$user) {
	
		// uEU̔
		$type = $this->getUserAgentType();
		$request->setAttribute('type', $type);
		
		$DB = $request->getAttribute('DB');
		$question_admin = unserialize($_SESSION['question_admin']);
		$number = $request->getParameter('number');
		$cid = $request->getParameter('cid');
		$eid = $request->getParameter('eid');
		$rid = $request->getParameter('rid');	
		$exam_admin = unserialize($_SESSION['exam_admin']);
		// 擾
		$request->setAttribute('admin', new Admin($user->getAttribute('aid'), $DB));

		// uցv{^ꂽ
		if($request->getParameter('next')){	
			$number += 1;
			// ̖肪ȂƂ
			$next = $exam_admin->getQuestionByNumber($number, $DB);
			if( $next->qid == '' || is_null($next->qid) ){
				$this->location('Exam', 'Confirm', array('rid'=>$rid));
				return VIEW_NONE;
			}		
			$this->location('Exam', 'Question', array('rid'=>$rid, 'number'=>$number));
			return VIEW_NONE;
		// u߂v{^ꂽ
		} else if($request->getParameter('back')){
			$request->setAttribute('eid', $eid);
			$request->setAttribute('rid', $rid);
			$request->setAttribute('number', $number);
			$this->location('Exam', 'Question', array('rid'=>$rid, 'number'=>$number));
			return VIEW_NONE;
		// uIv{^ꂽ
		} else if($request->getParameter('end')){		
			$this->location('Exam', 'Confirm', array('rid'=>$rid));
			return VIEW_NONE;
		}
		
		// ̉񓚂擾
		$choice_student = new StudentChoice($rid, $question_admin->qid, $DB);
		// 񓚂擾
		if (!is_null($cid) && $cid != ''){
			$choice_admin = new AdminChoice($cid, $DB);
			if($choice_admin->correct == '1'){
				$request->setAttribute('result', '');			
			} else{
				$request->setAttribute('result', 's');			
			}
		} else{
				$request->setAttribute('result', 's');		
		}	
		$question_admin->setChoices($DB);
		$correct = $question_admin->getCorrectValue();
		$request->setAttribute('exam_admin', $exam_admin);
		$request->setAttribute('count', unserialize($_SESSION['count']));
		$request->setAttribute('rid', $rid);
		$request->setAttribute('question_admin', $question_admin);
		$request->setAttribute('choice_student', $choice_student);
		$request->setAttribute('correct', $correct);
	
		return VIEW_SUCCESS;
    }
	
}

?>