<?php


// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: DBAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/20
//

require_once (OPT_DIR.'u-learning/lib/DBHandler.class.php');

/**
 * DBAction
 * 
 * DB接続を必要とするアクション
 */
class DBAction extends Action {

    /**
     * 初期化メソッド
     * 
     * Action の execute の前に呼ばれる
     */
    function initialize(& $controller, & $request, & $user) {
        if (!$request->hasAttribute('initialized')) {
            // 接続済みADODBを持つハンドラを作成
            $dbh = new DBHandler();

            //requestに接続を保管しておく
            $request->setAttribute('DB', $dbh);

            //何度も同じ処理をしないためのフラグ
            $request->setAttribute('initialized', TRUE);
        }
        return TRUE;
    }

}
?>