<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Mai Kawasaki                                                |
// +----------------------------------------------------------------------+
//
// $Id: StudentChoice.class.php,v 1.1 2005/06/20 09:31:26 snapshot Exp $
//
// Description:
// 2005/05/20
//

require_once (OPT_DIR.'u-learning/data/DataObject.class.php');

/**
 * StudentChoice
 * 
 * 学生テスト選択肢クラス
 */
class StudentChoice extends DataObject {

    // 回答ID
    var $rid;
    // 設問ID
    var $qid;
    // 選択肢ID
    var $cid;

    // 教員ID
    var $aid;
    // 学生ID
    var $uid;
    // テストID
    var $eid;

    // 選択肢内容
    var $choice;

    /**
     * コンストラクタ
     */
    function StudentChoice($rid= null, $qid= null, $db= null) {
        if (!is_null($rid) && !is_null($qid) && !is_null($db)) {
            $this->setDB($db);
            $this->rid= $rid;
            $this->qid= $qid;

            $sql= "SELECT * FROM user_choice WHERE qid = $qid and rid = $rid";
            $row= $this->DB->GetRow($sql);
            if (count($row) > 0) {
                $this->setValues($row);
            }
        }

    }

    /**
     * 配列から値をセットする
     */
    function setValues($array) {
        $this->rid= $array['rid'];
        $this->qid= $array['qid'];
        $this->cid= $array['cid'];
        $this->aid= $array['aid'];
        $this->uid= $array['uid'];
        $this->eid= $array['eid'];
        $this->choice= $array['choice'];
    }

    /**
     * 問題の選択情報登録
     */
    function insert($db= null) {
        $this->setDB($db);
        $sql= "insert into user_choice (rid,qid,cid,aid,uid,eid,choice) values (".$this->rid.", ".$this->qid.", ".$this->cid.", ".$this->DB->qstr($this->aid).", ".$this->DB->qstr($this->uid).", ".$this->eid.", ".$this->DB->qstr($this->choice).")";
        return $this->DB->Execute($sql);
    }

    /**
     * 問題の選択情報更新
     */
    function update($db= null) {
        $this->setDB($db);
        $sql= "update user_choice set "."cid = ".$this->cid.", "."aid = ".$this->DB->qstr($this->aid).", "."uid = ".$this->DB->qstr($this->uid).", "."eid = ".$this->eid.", "."choice = ".$this->DB->qstr($this->choice)." where rid = ".$this->rid." and qid = ".$this->qid;
        return $this->DB->Execute($sql);
    }

    /**
     * 問題の選択情報保存
     */
    function save($db= null) {
        $this->setDB($db);
        $sql= "select * from user_choice where "." rid = ".$this->rid." and qid = ".$this->qid;
        $row= $this->DB->GetRow($sql);
        if (count($row) > 0) {
            return $this->update($db);
        } else {
            return $this->insert($db);
        }

    }

    /**
     * 選択肢番号を取得する
     */
    function getNumber() {
        $select= "SELECT *";
        $from= "FROM admin_choice";
        $where= "WHERE qid = ".$this->qid;
        $order= "ORDER BY cid";
        $all= $this->DB->GetAll("$select $from $where $order");
        for ($i= 0; $i < count($all); $i ++) {
            if ($all[$i]['cid'] == $this->cid) {
                $this->number= $i +1;
                break;
            }
        }
		return $this->number;
    }

}
?>