<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: InputAction.class.php,v 1.1 2005/06/20 09:31:28 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');

/**
 * InputAction
 * 
 * 設定入力
 */
class InputAction extends AdminAction {

    /**
     * POST の処理
     */
    function execute(& $controller, & $request, & $user) {

        $DB= $request->getAttribute('DB');
        $admin= new Admin($user->getAttribute('aid'), $DB);

        $pass_current= $request->getParameter('pass_current');
        $pass_new= $request->getParameter('pass_new');
        $pass_new2= $request->getParameter('pass_new2');

        // 現パス・新パス・確認パスのいずれかが入力されていたとき
        if (strlen($pass_current) || strlen($pass_new) || strlen($pass_new2)) {
            if ($admin->pass != $pass_current) {
                $error= "現在のパスワードが違います。";
                $request->setAttribute('error', $error);
                return VIEW_ERROR;
            }
            if ($pass_new != $pass_new2) {
                $error= "確認用のパスワードが異なっています。";
                $request->setAttribute('error', $error);
                return VIEW_ERROR;
            }
            if (strlen($pass_new) < 4) {
                $error= "新しいパスワードは4文字以上にしてください。";
                $request->setAttribute('error', $error);
                return VIEW_ERROR;
            }
            // パスワードを更新
            $admin->pass= $request->getParameter('pass_new');
        }

        // 各設定を更新
        $admin->name= $request->getParameter('name');
        $admin->message= $request->getParameter('message');
        $admin->information= $request->getParameter('information');
        // DB更新
        $admin->update($DB);

        return VIEW_SUCCESS;
    }

    function getRequestMethods() {
        return REQ_POST;
    }

    /**
     * GET の処理
     */
    function getDefaultView(& $controller, & $request, & $user) {
        return VIEW_INPUT;
    }

}
?>