<?php

// +----------------------------------------------------------------------+
// | PHP version 4                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2005 Snapshot Inc.                                |
// +----------------------------------------------------------------------+
// | License                                                              |
// | GNU General Public License                                           |
// +----------------------------------------------------------------------+
// | Authors: Takayuki Tanimoto <takayuki@snapshot.co.jp>                 |
// +----------------------------------------------------------------------+
//
// $Id: ExamInfoAction.class.php,v 1.1 2005/06/20 09:31:27 snapshot Exp $
//
// Description:
// 2005/05/18
//

require_once (OPT_DIR.'u-learning/config.php');
require_once (OPT_DIR.'u-learning/action/AdminAction.class.php');
require_once (OPT_DIR.'u-learning/data/Admin.class.php');

/**
 * ExamInfoAction
 * 
 * 科目・テスト名変更
 */
class ExamInfoAction extends AdminAction {

    /**
     * GET/POST
     */
    function execute(& $controller, & $request, & $user) {
        // DBコネクション
        $db= $request->getAttribute('DB');
        // 教員取得
        $admin= new Admin($user->getAttribute('aid'), $db);

        // テスト取得
        $eid= $request->getParameter('eid');
        $exam= new AdminExam($eid, $db);

        // 次へボタン
        if ($request->hasParameter('exam_info_next')) {
            $exam->sid= $request->getParameter('sid');
            $exam->name= $request->getParameter('name');
            $exam->retry= $request->getParameter('retry');
            $exam->correct= $request->getParameter('correct');

            // DB更新
            $exam->update($db);

            // リダイレクト
            $this->location('Exam', 'Questions', array ('eid' => $eid));
            return VIEW_NONE;
        }

        // 科目取得
        $subjects= $admin->getSubjects($db);
        $request->setAttribute('subjects', $subjects);

        $request->setAttribute('exam', $exam);

        return VIEW_SUCCESS;
    }
}
?>