## チャンネルとは
チャンネルは、イメージファイルに含めるためのファイル（airootfs）やインストールするパッケージ、実行するスクリプトなどを簡単に切り替えられるように作られたAlterLinux独自の仕組みです。  
  
初期ではパッケージの切り替えしかできませんでしたが、現在は大幅に仕様が変更されています。  
  
以下は2020年3月26日チャンネルの仕様です。　　


## スクリプトにチャンネルを認識させる
スクリプトがチャンネルを認識する条件は以下のとおりです。

- `channel`内にチャンネル名のディレクトリがある
- そのディレクトリが空ではない

空のディレクトリを作成したり、別の場所に作成してもスクリプトは認識しません。


## それぞれのチャンネルの仕様
それそれのチャンネルは2つのディレクトリがあります。`airootfs`と`packages`です。  
`airootfs`ディレクトリはパッケージをインストールし`mksquashfs`を実行する直前に`/`を上書きします。  
`packages`ディレクトリはインストールするパッケージのリストを記述したテキストファイルを格納します。


### `airootfs`
このディレクトリ内を`/`としてファイルを配置して下さい。全てのファイルの権限はなるべく引き継がれるようになっています。  
  
#### customize_airootfs.sh
各チャンネルの`airootfs`で、`/root/customize_airootfs_<チャンネル名>.sh`といゆファイルが配置された場合、ビルドスクリプトは、`customize_airootfs.sh`が実行された後に実行します。  
もしrootfsの設定を変更したい場合、このファイルを作成して下さい。

#### 


### `packages`
このディレクトリ内に配置された、ファイル名が`.x86_64`で終わるがパッケージリストとして読み込まれます。  
1行で1つのパッケージとして扱い、`#`から始まる行はコメントとして扱われます。  
  
パッケージ名やパッケージリストのファイル名に空白文字や全角文字を含めると正常に動作しない可能性があります。

一部、パッケージリストに記述してはいけないパッケージが有ります。  
詳細は[こちら](packages.md)を参照して下さい。  


#### 特殊なパッケージリスト
特殊なパッケージリストとして、`jp.x86_64`と`non-jp.x86_64`があります。  
`-j`オプションによって日本語が有効化されている時、スクリプトは`jp.x86_64`を読み込みます。  
反対に日本語が有効化されていない場合、スクリプトは`non-jp.x86_64`を使用します。  


## 特殊なチャンネル
特殊なチャンネルとして`share`チャンネルがあります。`share`チャンネルは指定されたチャンネルに関わらず使用される共有チャンネルです。  
`share`はその他のチャンネルと同じ構造をしていますが、`share`単体をチャンネルとして指定してビルドすることはできません。  
全てのチャンネルでインストールされる基本パッケージや共通のファイルなどをここに追加します。  
  
`airootfs`でファイルが重複した場合、`share`のファイルは上書きされます。例えば`xfce`チャンネルでは`share`の`/root/customize_airootfs.sh`を上書きしています。
