/**********************************************************************
 * asym_u.c                                                 August 2005
 *
 * ASYM: An implementation of Asymetric Cryptography in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#include <stdio.h>

#include "unsx_e.h"
#include "pk_test.h"
#include "base64_test.h"
#include "pk.h"
#include "test_util.h"

#ifndef VERSION
#define VERSION "unknown"
#endif

int main(int argc, char **argv)
{
	char *str = "Fresh fish for all! Today Only!";
#if 0
	char n_str[64] = {
		0xe3, 0xf3, 0xba, 0x48, 0xdd, 0x2e, 0xbd, 0xa8, 
		0xe9, 0x87, 0x8e, 0x5f, 0x8a, 0x9e, 0xcb, 0xc9, 
		0x6d, 0xc1, 0x8b, 0x79, 0x31, 0xad, 0xb0, 0x26, 
		0x39, 0xba, 0xdc, 0x28, 0xd1, 0xf0, 0x20, 0x75, 
		0xa4, 0x24, 0xd2, 0xe8, 0x16, 0xe7, 0xb3, 0xb6, 
		0xaa, 0x39, 0xe5, 0xe2, 0x4c, 0xbf, 0x8e, 0x5f, 
		0x96, 0x4b, 0xcd, 0x09, 0x75, 0x71, 0xb1, 0x69, 
		0x1f, 0x67, 0xdf, 0xb7, 0xac, 0x58, 0x29, 0xa1
	};
#endif
	char n_str[64] = {
		0xe3, 0xf3, 0xba, 0x48, 0xdd, 0x2e, 0xbd, 0xa8,
		0xe9, 0x87, 0x8e, 0x5f, 0x8a, 0x9e, 0xcb, 0xc9,
		0x6d, 0xc1, 0x8b, 0x79, 0x31, 0xad, 0xb0, 0x26,
		0x39, 0xba, 0xdc, 0x28, 0xd1, 0xf0, 0x20, 0x75,
		0xa4, 0x24, 0xd2, 0xe8, 0x16, 0xe7, 0xb3, 0xb6,
		0xaa, 0x39, 0xe5, 0xe2, 0x4c, 0xbf, 0x8e, 0x5f,
		0x96, 0x4b, 0xcd, 0x09, 0x75, 0x71, 0xb1, 0x69,
		0x1f, 0x67, 0xdf, 0xb7, 0xac, 0x58, 0x29, 0xa1
	};
	char e_str[64] = {
		0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	};
	char plaintext_str[64] = {
		0x00, 0x02, 0x31, 0xb0, 0xc1, 0x82, 0xcb, 0xa2,
		0x56, 0x81, 0x62, 0xe0, 0xbe, 0xde, 0x17, 0x00,
		0x03, 0x00, 0x43, 0xc0, 0x06, 0x15, 0xe4, 0x0a, 
		0xe7, 0xfa, 0xb0, 0x8f, 0x6c, 0x95, 0xd7, 0x6b, 
		0xa6, 0x77, 0x30, 0x9a, 0xb8, 0x0d, 0x02, 0x54, 
		0xb9, 0x84, 0x21, 0x33, 0x0b, 0x9d, 0x46, 0x21, 
		0xec, 0xc7, 0x9b, 0xd0, 0xd7, 0x6c, 0xe3, 0xb5, 
		0x3f, 0xf9, 0x64, 0x1b, 0xe0, 0xfe, 0x5b, 0x83
	};
#if 0
	char plaintext_str[64] = {
		0x00, 0x02, 0x31, 0xb0, 0xc1, 0x82, 0xcb, 0xa2,
		0x56, 0x81, 0x62, 0xe0, 0xbe, 0xde, 0x17, 0x00,
		0x46, 0x72, 0x65, 0x73, 0x68, 0x20, 0x66, 0x69,
		0x73, 0x68, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x61,
		0x6c, 0x6c, 0x21, 0x20, 0x54, 0x6f, 0x64, 0x61,
		0x79, 0x20, 0x4f, 0x6e, 0x6c, 0x79, 0x21, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	};
#endif

	{
		char *enc = NULL;
		int encLen;
		char *dec = NULL;
		int decLen;
		char tmp[64];
		UNSX_NEW(n, 64 >> 2);
		UNSX_NEW(e, 64 >> 2);
		UNSX_NEW(plaintext, 64 >> 2);
		UNSX_NEW(dest, 64 >> 2);

		pk_init(64 << 3, 0);
		encLen = PK_ENC_LENGTH(64 << 3, PK_ALGO_RSA);
		enc = (char *) malloc(encLen);
		decLen = PK_ENC_LENGTH(64 << 3, PK_ALGO_RSA);
		dec = (char *) malloc(decLen);

		load_unsx_rev(n, n_str, 64 >> 2);
		load_unsx(e, e_str, 64 >> 2);
		load_unsx_rev(plaintext, plaintext_str, 64 >> 2);

		asym_print_char(KERN_DEBUG "plaintext", plaintext_str, 
				sizeof(plaintext_str));
		asym_print_unsx(KERN_DEBUG "plaintext", plaintext, 
				64 >> 2);
		asym_print_char(KERN_DEBUG "n", n_str, sizeof(n_str));
		asym_print_unsx(KERN_DEBUG "n", n, 64 >> 2);
		asym_print_char(KERN_DEBUG "e", e_str, sizeof(e_str));
		asym_print_unsx(KERN_DEBUG "e", e, 64 >> 2);

		unsx_modPow(dest, plaintext, e, n, 64>>2);
		asym_print_unsx(KERN_DEBUG "dest", dest, 64 >> 2);
		unload_unsx_rev(tmp, dest, 64 >> 2);
		asym_print_char(KERN_DEBUG "dest_str", tmp, 64);


		return(0);
	}

	printf("asym_u: (C) Jean-Luc Cooke <jlcooke@certainkey.com>. "
			"Version %s. Build %s %s\n", VERSION, 
			__DATE__, __TIME__);
	printf("testing: unsx_test: start\n");
	/* 
	if(unsx_test(1024) < 0) {
		printk(KERN_DEBUG "testing: unsx_test: failed\n");
	}
	else {
		printk(KERN_DEBUG "testing: unsx_test: ok\n");
	}
	*/
	if(pk_test(str, strlen(str), 512, PK_ALGO_RSA)) {
		printf("testing: pk_test RSA: failed\n");
	}
	else {
		printf("testing: pk_test RSA: ok\n");
	}
#if 0
	if(pk_test(str, strlen(str), 1024, PK_ALGO_ELGAMAL)) {
		printf("testing: pk_test ELGAMAL: failed\n");
	}
	else {
		printf("testing: pk_test ELGAMAL: ok\n");
	}
	if(base64_test(str, strlen(str))) {
		printf("testing: base_64_test: failed\n");
	}
	else {
		printf("testing: base_64_test: ok\n");
	}
#endif
	return(0);
}
