/**********************************************************************
 * compat.h                                                 August 2005
 *
 * ASYM: An implementation of Asymetric Cryptography in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef ASYM_COMPAT_H
#define ASYM_COMPAT_H

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <stdint.h>

typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef uint64_t u64;

#define GFP_KERNEL 1

#define kmalloc(x, y) malloc(x)
#define kfree(x) free(x)

#define KERN_DEBUG ""
#define printk(fmt, args...) printf(fmt, ## args )
/* #define printk(fmt, args...) do{ ; } while(0) */

/* This is very crappy, but I care not */
static inline void get_random_bytes(void *buf, size_t len)
{
	static int sranded=0;
	unsigned char *str = buf;
	if(!sranded) {
		srand((time(NULL) & 0x0000ffff) | 
				(getpid() << 16 & 0xffff0000));
		sranded++;
	}
	while(len--) {
		*str++ = (rand() >> 24) & 0xff;
	}
} 

#define yield() do{ ; } while(0)

#endif
