/**********************************************************************
 * log.h                                                    August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef KSSLD_KSSL_LOG_H
#define KSSLD_KSSL_LOG_H

#include "kssl_proc.h"

#ifdef CONFIG_KSSL_DEBUG
#define KSSL_DEBUG(level, msg...)					\
	do {								\
		if (level <= kssl_get_debug_level())			\
			printk(KERN_DEBUG "KSSLD: " msg);		\
	} while (0)
#define KSSL_NOTICE(level, msg...)					\
	do {								\
		if (level <= kssl_get_debug_level())			\
			printk(KERN_NOTICE "KSSLD: " msg);		\
	} while (0)
#else
#define KSSL_DEBUG(level, msg...)  do {} while (0)
#define KSSL_NOTICE(level, msg...)  do {} while (0)
#endif /* CONFIG_KSSL_DEBUG */

#endif /* KSSLD_KSSL_LOG_H */
