/**********************************************************************
 * session.h                                                August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef KSSL_SESSION_H
#define KSSL_SESSION_H

#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/sched.h>
#include <linux/wait.h>
#include <linux/unistd.h>
#include <linux/errno.h>

#include "types/base_t.h"
#include "types/security_parameters_t.h"
#include "types/cipher_suite_t.h"


typedef unsigned int kssl_session_id_t;

typedef struct {
	struct list_head list;
	atomic_t users;
	struct timer_list timer;
	kssl_session_id_t id;
	opaque_t master_secret[MASTER_SECRET_LEN];
	cipher_suite_t cs;
	compression_method_t cm;
} kssl_session_t;


kssl_session_id_t 
kssl_session_add(u32 addr, u16 port, cipher_suite_t *cs, 
		compression_method_t cm);

int
kssl_session_set_master_secret(kssl_session_id_t id,
                opaque_t master_secret[MASTER_SECRET_LEN]);

void
kssl_session_put(kssl_session_t *session);

void
kssl_session_invalidate(kssl_session_id_t id);

#define KSSL_SESSION_ID_LEN 32

void
kssl_session_str_generate(kssl_session_id_t id, u8 *buf);

kssl_session_t *
kssl_session_str_find(u8 *buf, size_t buf_len);

int __init 
kssl_session_init(void);

void __exit 
kssl_session_cleanup(void);

#endif /* KSSL_SESSION_H */

