/**********************************************************************
 * tcps.h                                                   August 2005
 *
 * TCPS: TCP Splicing Module
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _TCPS_H_
#define _TCPS_H_

/* sockopt */
#define TCPS_SO_BASE		(64+1024+64+64+64)	/* what this means?
							 * (took from tcpsp) */
#define TCPS_SO_SET_SOURCE_FAKE	TCPS_SO_BASE
#define TCPS_SO_SPLICE		(TCPS_SO_BASE+1)
#define TCPS_SO_SET_TCPOPT	(TCPS_SO_BASE+2)
#define TCPS_SO_GET_TCPOPT	(TCPS_SO_BASE+2)
#define TCPS_SO_SET_MAX		TCPS_SO_SET_TCPOPT
#define TCPS_SO_GET_MAX		TCPS_SO_GET_TCPOPT

struct tcps_tcpopt {
	int tstamp_ok;
#ifdef notyet
	int wscale_ok;
#endif
};

#ifdef __KERNEL__
/* #define TCPS_DEBUG */

#define TCPS_ERR(msg...)	printk(KERN_ERR "TCPS: " msg)
#define TCPS_INFO(msg...)	printk(KERN_INFO "TCPS: " msg)
#ifdef TCPS_DEBUG
#define TCPS_DBG(msg...)	printk(KERN_DEBUG "TCPS: " msg)
#else
#define TCPS_DBG(msg...)	do {} while (0)
#endif

#ifndef TCPS_CONN_TAB_BITS
#define TCPS_CONN_TAB_BITS	12
#endif

#define TCPS_CONN_TAB_SIZE	(1 << TCPS_CONN_TAB_BITS)
#define TCPS_CONN_TAB_MASK	(TCPS_CONN_TAB_SIZE - 1)

/* struct sock::tcpsinfo.flags bits */
#define TCPS_F_SOURCE_FAKE	0x0001
#define TCPS_F_SPLICED		0x0002

/* connection entry expiration timeout */
#define TCPS_CONN_TIMEOUT	(15 * 60 * HZ)
#define TCPS_CONN_TIMEOUT_FIN	(2 * 60 * HZ)

struct tcps_conn_tcpopt {
	u32 sseq;	/* init. send sequence number */
	u32 rseq;	/* init. recv sequence number */

	u32 ts_ok;
	u32 tsv;
	u32 tse;

	u32 csseq;	/* current send sequence number */
	u32 lack;	/* last ack number */
	u32 ltsv;	/* last timestamp value */
	u32 ltse;	/* last timestamp echo reply */
};

struct tcps_conn {
	struct list_head c_list;
	spinlock_t lock;
	struct timer_list timer;
	volatile unsigned long timeout;
	u32 caddr;
	u32 vaddr;
	u32 laddr;
	u32 raddr;
	u16 cport;
	u16 vport;
	u16 lport;
	u16 rport;
	u8 protocol;

#define TCPS_CONN_TCPOPT_CL		0
#define TCPS_CONN_TCPOPT_RS		1
	struct tcps_conn_tcpopt tcpopt[2];

	atomic_t refcnt;
#define TCPS_CONN_F_HASHED		0x0001
	u32 flags;
#define TCPS_CONN_S_NEW			0x0000
#define TCPS_CONN_S_SPLICED		0x0001
#define TCPS_CONN_S_RS_SENT		0x0002
#define TCPS_CONN_S_CL_SENT		0x0004
#define TCPS_CONN_S_RS_FIN		0x0008
#define TCPS_CONN_S_CL_FIN		0x0010
#define TCPS_CONN_S_EXPIRED		0x0020
	u32 state;

	struct sock *csk;
	struct sock *rsk;
};


/*
 * function prototypes
 */

/* core functions */
extern void tcps_reset_sock(struct sock *sk);

/* connection functions */
extern int tcps_conn_init(void);
extern void tcps_conn_fini(void);
extern void tcps_conn_set_state(struct tcps_conn *tc, u32 state);
extern void tcps_conn_expire_now(struct tcps_conn *tc);
extern struct tcps_conn *tcps_conn_new(__u32 laddr, __u16 lport,
				       __u32 raddr, __u16 rport,
				       __u32 caddr, __u16 cport);
extern void tcps_conn_free(struct tcps_conn *tc);
extern int tcps_conn_hash(struct tcps_conn *tc);
extern int tcps_conn_unhash(struct tcps_conn *tc);
extern struct tcps_conn *tcps_conn_in_get(__u32 caddr, __u16 cport, 
					  __u32 vaddr, __u16 vport);
extern struct tcps_conn *tcps_conn_out_rs_get(__u32 caddr, __u16 cport, 
					      __u32 laddr, __u16 lport);
extern struct tcps_conn *tcps_conn_out_cl_get(__u32 caddr, __u16 cport, 
					      __u32 vaddr, __u16 vport);
extern struct tcps_conn *tcps_conn_preroute_get(__u32 caddr, __u16 cport,
						__u32 raddr, __u16 rport);
extern void tcps_conn_put(struct tcps_conn *tc);

/* timer functions */
extern void add_sltimer(struct timer_list *timer);
extern void mod_sltimer(struct timer_list *timer, unsigned long expires);
extern int del_sltimer(struct timer_list * timer);
extern void tcps_sltimer_init(void);
extern void tcps_sltimer_cleanup(void);

#endif /* __KERNEL__ */
#endif
