/**********************************************************************
 * TCPS (TCP Splicing Module)
 *
 * tcps_compat.h:
 *   Wrapper functions and macros for compatibility of 2.4 and 2.6.
 *
 * Copyright (C) 2006  Hirotaka Sasaki <hiro1967@mti.biglobe.ne.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _TCPS_COMPAT_H
#define _TCPS_COMPAT_H

#include <linux/config.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/skbuff.h>
#include <linux/ip.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/icmp.h>
#include <net/ip.h>
#include <net/sock.h>

/*
 *  for RHEL4 and Sarge(kernel2.6)
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)

#define TCPS_SK_TCPSI(__sk)         ((__sk)->sk_user_data)
#define TCPS_SK_STATE(__sk)         ((__sk)->sk_state)
#define TCPS_SK_PROTOCOL(__sk)      ((__sk)->sk_protocol)
#define TCPS_SK_DADDR(__sk)         ((inet_sk((__sk)))->daddr)
#define TCPS_SK_DPORT(__sk)         ((inet_sk((__sk)))->dport)
#define TCPS_SK_RCVADDR(__sk)       ((inet_sk((__sk)))->rcv_saddr)
#define TCPS_SK_SPORT(__sk)         ((inet_sk((__sk)))->sport)
#define TCPS_SK_FL_DEAD(__sk)       (sock_flag((__sk), SOCK_DEAD))
#define TCPS_SK_ERR(__sk)           ((__sk)->sk_err)
#define TCPS_SK_ERR_REPORT(__sk)    ((__sk)->sk_error_report((__sk)))
#define TCPS_SK_INODE(__sk) \
            ((__sk)->sk_socket ? SOCK_INODE((__sk)->sk_socket) : NULL)

static inline
int tcps_ip_route_output(struct rtable **rp, u32 daddr, u32 saddr,
                         u32 tos, int oif)
{
	struct flowi fl = {
		.oif = oif,
		.nl_u = {
			.ip4_u = {
				.daddr = daddr,
				.saddr = saddr,
				.tos = tos
			}
		}
	};

    return ip_route_output_key(rp, &fl);
}

static inline
int tcps_ip_send(struct sk_buff *skb)
{
	return dst_output(skb);
}

/*
 *  for RHEL3 and Sarge(kernel2.4)
 */
#elif (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,21) \
         && defined(RED_HAT_LINUX_KERNEL)) \
      || \
      (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,27) \
         && defined(DEBIAN_3_1_LINUX_KERNEL))

#define TCPS_SK_TCPSI(__sk)         ((__sk)->user_data)
#define TCPS_SK_STATE(__sk)         ((__sk)->state)
#define TCPS_SK_PROTOCOL(__sk)      ((__sk)->protocol)
#define TCPS_SK_DADDR(__sk)         ((__sk)->daddr)
#define TCPS_SK_DPORT(__sk)         ((__sk)->dport)
#define TCPS_SK_RCVADDR(__sk)       ((__sk)->rcv_saddr)
#define TCPS_SK_SPORT(__sk)         ((__sk)->sport)
#define TCPS_SK_FL_DEAD(__sk)       ((__sk)->dead)
#define TCPS_SK_ERR(__sk)           ((__sk)->err)
#define TCPS_SK_ERR_REPORT(__sk)    ((__sk)->error_report((__sk)));
#define SOCKET_I(__inode)           (&(__inode)->u.socket_i)
#define TCPS_SK_INODE(__sk) \
            ((__sk)->socket ? SOCK_INODE((__sk)->socket) : NULL)

static inline
int tcps_ip_route_output(struct rtable **rp, u32 daddr, u32 saddr,
                         u32 tos, int oif)
{
	struct flowi fl = {
		.oif = oif,
		.nl_u = {
			.ip4_u = {
				.daddr = daddr,
				.saddr = saddr,
				.tos = tos
			}
		}
	};

    return ip_route_output_key(rp, &fl);
}

static inline
int tcps_ip_send(struct sk_buff *skb)
{
	return dst_output(skb);
}

/*
 *  for Vanilla kernel 2.4.x
 */
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,26)

#define TCPS_SK_TCPSI(__sk)         ((__sk)->user_data)
#define TCPS_SK_STATE(__sk)         ((__sk)->state)
#define TCPS_SK_PROTOCOL(__sk)      ((__sk)->protocol)
#define TCPS_SK_DADDR(__sk)         ((__sk)->daddr)
#define TCPS_SK_DPORT(__sk)         ((__sk)->dport)
#define TCPS_SK_RCVADDR(__sk)       ((__sk)->rcv_saddr)
#define TCPS_SK_SPORT(__sk)         ((__sk)->sport)
#define TCPS_SK_FL_DEAD(__sk)       ((__sk)->dead)
#define TCPS_SK_ERR(__sk)           ((__sk)->err)
#define TCPS_SK_ERR_REPORT(__sk)    ((__sk)->error_report((__sk)));
#define SOCKET_I(__inode)           (&(__inode)->u.socket_i)
#define TCPS_SK_INODE(__sk) \
            ((__sk)->socket ? SOCK_INODE((__sk)->socket) : NULL)
#ifndef tcp_sk
#define tcp_sk(__sk)				(&(__sk)->tp_pinfo.af_tcp)
#endif

static inline
int tcps_ip_route_output(struct rtable **rp, u32 daddr, u32 saddr,
                         u32 tos, int oif)
{
	return ip_route_output(rp, daddr, saddr, tos, oif);
}

static inline
int tcps_ip_send(struct sk_buff *skb)
{
	return ip_send(skb);
}

/*
 *  Other kernels
 */
#else
#error "Not support your kernel version."
#endif

#endif /* _TCPS_COMPAT_H */
