/*!
 * @file  l7vs_lsock.h
 * @brief The listening socket is managed. 
 *
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/
#ifndef	L7VS_LSOCK_H
#define	L7VS_LSOCK_H

#include <netinet/in.h>
#include <glib.h>
#include <stdint.h>
#include "l7vs_iom.h"

// listen socket datatype. accepts client connections.
struct	l7vs_lsock{
	struct	sockaddr_in	addr;
	uint8_t			proto;
	struct	l7vs_iomux*	iom;
	int			refcnt;
	GList*			srv_list;
};

struct	l7vs_service;
struct	l7vs_conn;
struct	l7vs_dest;

//
// functions
//
extern	int			l7vs_lsock_init();
extern	void			l7vs_lsock_fini();
extern	struct l7vs_lsock*	l7vs_lsock_get( struct sockaddr_in*, uint8_t, int );
extern	void			l7vs_lsock_put( struct l7vs_lsock* );
extern	struct l7vs_lsock*	l7vs_lsock_table_lookup( struct sockaddr_in*, uint8_t );
extern	void			l7vs_lsock_add_service( struct l7vs_lsock*, struct l7vs_service* );
extern	void			l7vs_lsock_remove_service( struct l7vs_lsock*, struct l7vs_service* );

extern	int		l7vs_lsock_select_service(
				struct l7vs_lsock*,
				struct l7vs_conn*,
				char*,
				size_t,
				struct l7vs_service**,
				struct l7vs_dest**,
				int* );

#endif	//L7VS_LSOCK_H

