/**********************************************************************
 * module_http.h                                               May 2007 
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/
#ifndef	MODULE_HTTP_H
#define	MODULE_HTTP_H

#define EXPIRE_MAXSIZE         (64)
#define COOKIE_NAME_MAXSIZE    (128)
#define SERVICE_ARG_MAXSIZE    (512)
#define CINSERT_SERVICE_NUMBER (16)

//
// functions
//

extern void  http_cookie_expire(time_t expire_t, char* expire_c);
extern int   http_check_response_status(char *res);
extern char* http_check_request_method(char *req, size_t *length);
extern void  http_encode_address(char *encoded, const u_long s_addr, const u_short sin_port);
extern void  http_decode_address(char *encoded, u_long *s_addr, u_short *sin_port);
extern char* http_search_header_cookie_value(char *http_header, char *cookie_name);
extern char* http_search_header_field(char *http_header, char *search_name);
extern char* http_skip_header_line(char *top_ptr);

#endif	//MODULE_HTTP_H
