/*
 * @file	l7vs_conn.h
 * @bref	Connection is managed. 
 * @bref	The previous substance becomes one conn though two iom is registered
 * @bref	in sets of imoux so that conn may have sockaddr for a real server 
 * @bref	and sockaddr for the client internally. 
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/
#ifndef	L7VS_CONN_H
#define	L7VS_CONN_H

#include <netinet/in.h>
#include "l7vs_iom.h"
#include "tcps.h"

#define	FDSET_SIZE	(8192)
struct	my_fd_set{
	char	x[FDSET_SIZE];
};
#undef	FD_ZERO
#define	FD_ZERO(ptr) memset((ptr), 0, FDSET_SIZE)

// connection management datatype
#define	L7VS_CLDATA_CHUNKSIZE	(512)
#define	L7VS_CLDATA_BUFSIZE(L)	(((L)->cldata_len + L7VS_CLDATA_CHUNKSIZE - 1) & ~(L7VS_CLDATA_CHUNKSIZE - 1))
#define	L7VS_CLDATA_REST(L)	(L7VS_CLDATA_BUFSIZE(L) - (L)->cldata_len)

#define	L7VS_CONN_S_CL_CONNECTED	0
#define	L7VS_CONN_S_RS_CONNECTING	1
#define	L7VS_CONN_S_RS_CONNECTED	2

struct	l7vs_conn{
	struct	l7vs_lsock*	lsock;	//! l7vs_lsock pointer
	struct	l7vs_service*	srv;	//! l7vs_service pointer
	struct	l7vs_dest*	dest;	//! real server pointer
	int			splice;	//! tcp splice handle (don't use)
	struct	sockaddr_in	caddr;	//! client sockaddr struct
	struct	sockaddr_in	raddr;	//! real server sockaddr struct
	struct	sockaddr_in	vaddr;	//! 
	struct	sockaddr_in	laddr;  //! 
//	struct	l7vs_iomux	ciom;	//!	client-side socket
//	struct	l7vs_iomux	riom;	//!	realserver-side socket
	struct	l7vs_iomux*	ciom;	//!	client-side socket
	struct	l7vs_iomux*	riom;	//!	realserver-side socket	
	uint8_t			proto;	//!
	uint32_t		state;	//! connn status
	char*			cldata; //! client data buffer
	size_t			cldata_len; //! client data buffer length
	size_t			cldata_bufsize; //! client buffer size
	struct	tcps_tcpopt	tcpopt;	//! tcps option
	int			cmss;	//! cmess??
	struct	timeval		recvtime;//! client data recv time
	size_t			recvsize;//! client data recv size
	int			sorry_conn_flag; //! sorry connection flag
	struct  l7vs_dest*	old_dest; //! old destination
};

//
// functions.
//
extern	struct	l7vs_conn*	l7vs_conn_create( int, struct l7vs_lsock* );
extern	void			l7vs_conn_destroy( struct l7vs_conn* );
//extern	int			l7vs_conn_recv_client( struct l7vs_conn* );
extern	int			l7vs_conn_connect_rs( struct l7vs_conn*, struct l7vs_dest* );
//extern	int			l7vs_conn_splice( struct l7vs_conn* );
extern	void			l7vs_conn_close_csock( struct l7vs_conn* );
extern	void			l7vs_conn_close_rsock( struct l7vs_conn* );
extern	int			l7vs_conn_closed( struct l7vs_conn* );

#endif	//L7VS_CONN_H


