/*!
 * @file l7vs_iomuxlist.c
 * @brief This file manages sets of iomux. 
 * @brief It becomes the foundation of the event call of FD using sets of iomux 
 * @bried and epoll. 
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/
#ifndef	L7VS_IOMUXLIST_H
#define	L7VS_IOMUXLIST_H

#define L7VS_IOMUX_LIST_UNCHANGED       0
#define L7VS_IOMUX_LIST_REMOVED_MYSELF  1
#define L7VS_IOMUX_LIST_REMOVED_OTHER   2

#include "l7vs_iom.h"
#include <stdint.h>

extern int			l7vs_iomux_init();
extern void			l7vs_iomux_fini();
extern struct l7vs_iomux*	l7vs_iomux_get_from_avail_list();
extern void			l7vs_iomux_put_to_avail_list(struct l7vs_iomux*);
extern void			l7vs_iomux_add( struct l7vs_iomux*, enum iomaction );
extern void			l7vs_iomux_remove( struct l7vs_iomux* );
extern void			l7vs_iomux_mod( struct l7vs_iomux*, enum iomaction );
extern void			l7vs_iomux_removeall();
extern int			l7vs_iomux_poll( struct timeval*, int );

#endif	//L7VS_IOMUXLIST_H
