/**********************************************************************
 * l7vs_sched.h                                                May 2007
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/
#ifndef	L7VS_SCHED_H
#define	L7VS_SCHED_H

#include "l7vs_module.h"

struct	l7vs_service;
struct	l7vs_conn;
struct	l7vs_dest;

// scheduler datatype
struct	l7vs_scheduler{
	void*			handle;
	char			modname[L7VS_MODNAME_LEN+1];
	int			refcnt;
	struct l7vs_dest*	(*schedule)( struct l7vs_service*, struct l7vs_conn*);
	void			(*bind)( struct l7vs_service*);
	void			(*unbind)(struct l7vs_service*);
	void			(*fini)();
};

//
// finctions.
//
extern	struct l7vs_scheduler*	l7vs_sched_get(char*);
extern	void			l7vs_sched_put( struct l7vs_scheduler* );
extern	void			l7vs_sched_bind( struct l7vs_scheduler*, struct l7vs_service* );
extern	void			l7vs_sched_unbind( struct l7vs_scheduler*, struct l7vs_service* );
extern	int			l7vs_sched_sorry_check(struct l7vs_service*, int);
extern	struct l7vs_dest*	l7vs_sched_sorry_dest(struct l7vs_service*, struct l7vs_conn*, int);

#endif	//L7VS_SCHED_H
