/* 
 * @file	l7vs_service.h
 * @bref	service that brings function of l7vsd together.
 * @bref	It has sets of conn of ther service.
 * @bref	and sets of read servers.
 * @bref	and protocol module
 * @bref	and schedulers.
 *
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/
#ifndef	L7VS_SERVICE_H
#define	L7VS_SERVICE_H

#include <stdint.h>
#include <glib.h>
#include "l7vs_conn.h"
#include "l7vs.h"

struct	l7vs_lsock;
struct	l7vs_scheduler;
struct	l7vs_protomod;
struct	l7vs_dest;
struct	l7vs_dest_arg;

typedef	uint32_t	handle_t;
#define TEMP_SERVICEHANDLE UINT32_MAX

// virtual service definition datatype
struct	l7vs_service{
	handle_t		handle;			//! l7vs_service_handle
	struct	l7vs_lsock*	lsock;			//! listen socket struct pointer
	GList*			dest_list;		//! real server list
//	GList*			conn_list;
	GHashTable*		conn_hash;		//! connection table
	struct	l7vs_scheduler*	scheduler;		//! scheduler pointer
	void*		sched_data;			//! scheduler data pointer
	struct	l7vs_protomod*	pm;			//! protocol module pointer

	// ...and per-module match-data follows
	char		protomod_opt_string[512];	//! protocol module option string
	char		protomod_key_string[256];	//! protocol module key string
	int		reschedule;			//! reschedule flag
	int			sorry_cc;		//! sorry connection count limit
	struct	l7vs_dest*	sorry_dest;		//! sorry-server destination
	int			sorry_flag;		//! sorry flag

	unsigned long long	QoS_threshold_service;	//! QoS threashold value for Virtual Service
	unsigned long long	QoS_threshold_conn;	//! QoS threashold value for Client Connection
	struct	timeval	recvtime;			//! Receiving interval
	size_t		recvsize;			//! data recive size
};

//	virtual service definition, external representation.
struct	l7vs_service_arg{
	size_t			len;			//! structure size
	struct sockaddr_in	addr;			//! server address
	uint8_t			proto;			//! server transport protocol
	int			persist;		//! persistency
	int			backlog;		//! listen(2) backlog length
	char			protomod[L7VS_MODNAME_LEN];	//! protocol module name
	char			schedmod[L7VS_MODNAME_LEN];	//! scheduler

	// ... and protocol-module defined data follows
	char			protomod_opt_string[512];//! protocol module option string
	char			protomod_key_string[256];//! protocol module key string
	int			reschedule;		 //! reshcedule
	int			sorry_cc;		//! sorry connection count limit
	struct sockaddr_storage	sorry_addr;		//! sorry-server address
	int			sorry_flag;		//! sorry flag
	unsigned long long	qos_s;			//! QoS Threashold value for Virtual Service
	unsigned long long	qos_c;			//! QoS Threashold value for Client Connections
};

//	message of virtual service and protocol module definition, external representation.
struct	l7vs_service_arg_multi{
	struct l7vs_service_arg srv_arg;
	char protomod_arg[L7VS_PROTOMOD_MAX_SERVICE_ARG];
};

//
// functions
//
extern	struct l7vs_service*	l7vs_service_create( struct l7vs_service_arg_multi*, int* );
extern	int			l7vs_service_destroy( struct l7vs_service* );
extern	struct l7vs_service*	l7vs_service_lookup( struct l7vs_service_arg_multi* );
extern	int			l7vs_service_add_dest( struct l7vs_service*, struct l7vs_dest_arg* );
extern	int			l7vs_service_remove_dest( struct l7vs_service*, struct l7vs_dest_arg* );
extern	int			l7vs_service_schedule( struct l7vs_service*, struct l7vs_conn* );
extern	int			l7vs_service_establish( struct l7vs_service*, struct l7vs_conn* );
extern	struct l7vs_dest*	l7vs_service_lookup_dest( struct l7vs_service*, struct sockaddr_in* );
extern	int			l7vs_service_list_service_arg( struct l7vs_service_arg_multi**, int* );
extern	int			l7vs_service_list_dest_arg( struct l7vs_service*, struct l7vs_dest_arg** );
extern	int			l7vs_service_register_conn( struct l7vs_service*, struct l7vs_conn* );
extern	int			l7vs_service_remove_conn( struct l7vs_service*, struct l7vs_conn* );
extern	void			l7vs_service_flush_all();
extern	int			l7vs_service_set_QoS_Threashold( struct l7vs_service * srv, struct l7vs_service_arg_multi * arg );
extern	int			l7vs_service_set_SorryServer_Values( struct l7vs_service * srv, struct l7vs_service_arg_multi * arg );

#endif	//L7VS_SERVICE_H
