/*! @file
 *  @brief Sync module header
 *
 *  @author NTT COMWARE
 *  @date 2007-07-24
 *  @version 0.1
 */

#ifndef SYNC_H
#define SYNC_H


//! It is an argument used by the module of sync .
struct l7vs_sync_iom {
	enum   sync_operation mode; //!< Operation mode
	void * memory;              //!< Top of memory address
	size_t block_num;           //!< Number of memory block
	size_t number;              //!< Turn number of memory block
};

/*! Aquire the memory.
 *
 *  @return sync_iom Memory. (void *memory, NULL)
 *  @retval nonnull Memory.
 *  @retval NULL Error.
 */
extern void * l7vs_sync_get_memory(size_t block_num);


/*! Sync CallBack
 *
 *  @return CallBack results.(0 , 1)
 *  @retval 0 Everything is ok.
 *  @retval 1 Error.
 */
extern int    l7vs_sync_callback(struct l7vs_iomux *iom);


/*! Send sync data (1 block)
 *
 *  @result Send results.(0 , 1)
 *  @retval 0 Everything is ok.
 *  @retval 1 Error.
 */
extern int   l7vs_sync_send();


/*! Receive sync data (1 block)
 *
 *  @return Recive results.(0 , 1)
 *  @retval 0 Everything is ok.
 *  @retval 1 Error.
 */
extern int   l7vs_sync_recv();


/*! Initialize sync
 *
 * @param block_num Memory block number.
 * @param mode Operation mode. (0 : send, 1: receive)
 * @param fd File descriptor.
 *
 * @return Initialize results. (0 , 1)
 * @retval 0 Everything is ok
 * @retval 1 Error
 */
extern int    l7vs_sync_init(struct l7vs_sync_init_data *);


/*! Finalize sync
 *
 *  @return Finalize results. (0 , 1)
 *  @retval 0 Everything is ok.
 *  @retval 1 Error.
 */
extern int    l7vs_sync_fini();


/*! Return the memory size
 *
 *  @return Memory size (memory_size, NULL)
 *  @retval nonnull Memory size.
 *  @retval NULL Error.
 */
extern size_t l7vs_sync_memory_size();


/*! Return the top of memory address.
 *
 *  @return Top of memory address.
 *  @retval sync_iom.memory Everything is ok.
 *  @retval NULL Error.
 */
extern void * l7vs_sync_memory_addr();

#define L7VS_PROTOMOD_MAX_BLOCK   10           /*! protocol module max block number */

#endif /* SYNC_H */
