/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.controller;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.ClusterData;
import org.ultramonkey.l7.controller.ClusterStatus;

public class ClusterController {
    private Logger ioCommandLogger = Logger.getLogger((String)"l7gui_I/O.Command");
    protected static ClusterData data = null;
    private static final String CRM_MON = "/usr/sbin/crm_mon";
    private static final String CRM_STANDBY = "/usr/sbin/crm_standby";
    private static final int CHECK_TIMEOUT = 10;
    private static String HB_LOG = "/var/log/ha-log";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterData getData() {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)"11558 ClusterController::getData() in");
        }
        ClusterController clusterController = this;
        synchronized (clusterController) {
            ClusterData data;
            block16: {
                String command = "/usr/sbin/crm_mon -1";
                String result = this.runProcess(command);
                data = new ClusterData();
                data.self_status = ClusterStatus.SINGLE;
                data.logFileName = HB_LOG;
                try {
                    InetAddress local = InetAddress.getLocalHost();
                    String host = local.getHostName();
                    data.self_ip = local.getHostAddress();
                    if (result == null) break block16;
                    Pattern p = Pattern.compile("^Node: ([^ ]+)[^:]+: (\\w+)$", 8);
                    Matcher m = p.matcher(result);
                    while (m.find()) {
                        if (host.equals(m.group(1))) {
                            data.self_hostname = m.group(1);
                            data.self_ip = local.getHostAddress();
                            if ("OFFLINE".equals(m.group(2))) {
                                data.self_status = ClusterStatus.OUT_OF_SERVICE;
                                continue;
                            }
                            if ("online".equals(m.group(2))) {
                                data.self_status = ClusterStatus.STANDBY;
                                continue;
                            }
                            if ("standby".equals(m.group(2))) {
                                data.self_status = ClusterStatus.OUT_OF_SERVICE;
                                continue;
                            }
                            data.self_status = ClusterStatus.SINGLE;
                            continue;
                        }
                        data.other_hostname = m.group(1);
                        try {
                            data.other_ip = InetAddress.getByName(m.group(1)).getHostAddress();
                        }
                        catch (UnknownHostException e) {
                            this.ioCommandLogger.info((Object)("21100 name resolution failed: " + m.group(1)));
                            data.other_ip = null;
                        }
                        data.other_status = "OFFLINE".equals(m.group(2)) ? ClusterStatus.OUT_OF_SERVICE : ("online".equals(m.group(2)) ? ClusterStatus.STANDBY : ("standby".equals(m.group(2)) ? ClusterStatus.OUT_OF_SERVICE : ClusterStatus.SINGLE));
                    }
                    p = Pattern.compile("Started ([-\\.\\w]+)$", 8);
                    m = p.matcher(result);
                    while (m.find()) {
                        if (m.group(1).equals(data.self_hostname) && data.self_status == ClusterStatus.STANDBY) {
                            data.self_status = ClusterStatus.ACTIVE;
                            continue;
                        }
                        if (!m.group(1).equals(data.other_hostname) || data.other_status != ClusterStatus.STANDBY) continue;
                        data.other_status = ClusterStatus.ACTIVE;
                    }
                }
                catch (Exception e) {
                    this.ioCommandLogger.error((Object)("41242 Exception occured: " + e.getMessage()));
                    data = null;
                }
            }
            if (this.ioCommandLogger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("ClusterController::getData() out ");
                buf.append("return=(" + data + ")");
                this.ioCommandLogger.debug((Object)("11559 " + buf.toString()));
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(ClusterData cd) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("ClusterController::setData(ClusterData cd) in ");
            buf.append("cd=(" + cd + ")");
            this.ioCommandLogger.debug((Object)("11560 " + buf.toString()));
        }
        ClusterController clusterController = this;
        synchronized (clusterController) {
            data = cd;
        }
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)"11561 ClusterController::setData(ClusterData cd) out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changeClusterMode() {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)"11562 ClusterController::changeClusterMode() in");
        }
        ClusterController clusterController = this;
        synchronized (clusterController) {
            ClusterData data = this.getData();
            String command = null;
            boolean self_flag = true;
            if (data != null && data.self_status == ClusterStatus.ACTIVE && data.other_status == ClusterStatus.STANDBY) {
                self_flag = true;
                command = "/usr/sbin/crm_standby -U " + data.self_hostname + " -v on";
            } else if (data != null && data.other_status == ClusterStatus.ACTIVE && data.self_status == ClusterStatus.STANDBY) {
                self_flag = false;
                command = "/usr/sbin/crm_standby -U " + data.other_hostname + " -v on";
            } else {
                this.ioCommandLogger.error((Object)("41243 Invalid status: " + data));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11563 ClusterController::changeClusterMode() out return=false");
                }
                return false;
            }
            String result = this.runProcess(command);
            if (result == null || result.length() != 0) {
                this.ioCommandLogger.error((Object)("41244 Command error: command=" + command));
                this.ioCommandLogger.error((Object)("41245 Command error:  result=" + result));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11564 ClusterController::changeClusterMode() out return=false");
                }
                return false;
            }
            int timeout = 10;
            while (true) {
                if ((data = this.getData()) == null) {
                    this.ioCommandLogger.error((Object)("41246 Invalid status: " + data));
                    if (this.ioCommandLogger.isDebugEnabled()) {
                        this.ioCommandLogger.debug((Object)"11565 ClusterController::changeClusterMode() out return=false");
                    }
                    return false;
                }
                if (self_flag) {
                    if (data.self_status == ClusterStatus.OUT_OF_SERVICE && data.other_status == ClusterStatus.ACTIVE) {
                        command = "/usr/sbin/crm_standby -U " + data.self_hostname + " -v off";
                        break;
                    }
                } else if (data.other_status == ClusterStatus.OUT_OF_SERVICE && data.self_status == ClusterStatus.ACTIVE) {
                    command = "/usr/sbin/crm_standby -U " + data.other_hostname + " -v off";
                    break;
                }
                if (--timeout <= 0) {
                    this.ioCommandLogger.error((Object)"41247 Switch-Over timeout(10sec)");
                    if (this.ioCommandLogger.isDebugEnabled()) {
                        this.ioCommandLogger.debug((Object)"11566 ClusterController::changeClusterMode() out return=false");
                    }
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.ioCommandLogger.error((Object)("41248 Exception occured: " + e.getMessage()));
                    if (this.ioCommandLogger.isDebugEnabled()) {
                        this.ioCommandLogger.debug((Object)"11567 ClusterController::changeClusterMode() out return=false");
                    }
                    return false;
                }
            }
            result = this.runProcess(command);
            if (result == null || result.length() != 0) {
                this.ioCommandLogger.error((Object)("41249 Command error: command=" + command));
                this.ioCommandLogger.error((Object)("41250 Command error:  result=" + result));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11568 ClusterController::changeClusterMode() out return=false");
                }
                return false;
            }
            data = this.getData();
            if (data == null) {
                this.ioCommandLogger.error((Object)"41251 Invalid status: null");
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11569 ClusterController::changeClusterMode() out return=false");
                }
                return false;
            }
            if (self_flag) {
                if (data.self_status != ClusterStatus.STANDBY || data.other_status != ClusterStatus.ACTIVE) {
                    this.ioCommandLogger.error((Object)("41252 Invalid status: " + data));
                    if (this.ioCommandLogger.isDebugEnabled()) {
                        this.ioCommandLogger.debug((Object)"11570 ClusterController::changeClusterMode() out return=false");
                    }
                    return false;
                }
            } else if (data.other_status != ClusterStatus.STANDBY || data.self_status != ClusterStatus.ACTIVE) {
                this.ioCommandLogger.error((Object)("41253 Invalid status: " + data));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11571 ClusterController::changeClusterMode() out return=false");
                }
                return false;
            }
            if (this.ioCommandLogger.isDebugEnabled()) {
                this.ioCommandLogger.debug((Object)"11572 ClusterController::changeClusterMode() out return=true");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String runProcess(String command) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("ClusterController::runProcess(String command) in ");
            buf.append("command=\"" + command + "\"");
            this.ioCommandLogger.debug((Object)("11573 " + buf.toString()));
        }
        ClusterController clusterController = this;
        synchronized (clusterController) {
            StringBuffer result = new StringBuffer();
            try {
                Process p = Runtime.getRuntime().exec("sudo " + command);
                InputStream stderr = p.getErrorStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(stderr));
                String line = null;
                while ((line = br.readLine()) != null) {
                    result.append(String.valueOf(line) + "\n");
                }
                InputStream is = p.getInputStream();
                br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    result.append(String.valueOf(line) + "\n");
                }
            }
            catch (Exception e) {
                this.ioCommandLogger.error((Object)("41254 Exception occured: " + e.getMessage()));
                result = null;
            }
            if (this.ioCommandLogger.isDebugEnabled()) {
                this.ioCommandLogger.debug((Object)("11574 ClusterController::runProcess(String command) out return=" + result));
            }
            return result == null ? null : result.toString();
        }
    }
}

