/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.DirectorData;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SessionTransData;
import org.ultramonkey.l7.view.CommandExecuter;
import org.ultramonkey.l7.view.L7guiServletBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorSetServlet
extends L7guiServletBase {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public MonitorSetServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11485 class MonitorSetServlet created.");
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("MonitorServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11486 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            this.logger.debug((Object)("11487 QueryString=\"" + request.getQueryString() + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11488 MonitorServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectPage;
        ExecuteMode mode;
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11489 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11490 PostData=\"" + post + "\""));
        }
        super.doPost(request, response);
        HttpSession session = request.getSession(false);
        if (!this.login || session == null) {
            if (session != null) {
                MessageView error = new MessageView(41211, "l7gui_UserAuthentication", "Invalid session.");
                session.setAttribute("resultMessage", (Object)error);
            }
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11491 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        request.setCharacterEncoding("UTF-8");
        HashMap tmpMap = (HashMap)request.getParameterMap();
        if (tmpMap == null) {
            MessageView error = new MessageView(41212, "l7gui_I/O.File", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11492 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        HashMap<String, String> inputMonitorMap = new HashMap<String, String>();
        for (String key : tmpMap.keySet()) {
            inputMonitorMap.put(key, ((String[])tmpMap.get(key))[0]);
        }
        L7guiFramework frame = new L7guiFramework();
        DirectorData monitorInfo = frame.getDirectorData();
        if (monitorInfo == null) {
            MessageView error = new MessageView(41213, "l7gui_I/O.File", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11493 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        boolean validationFlag = true;
        HashMap<String, String> invalidMap = new HashMap<String, String>();
        validationFlag = this.validationCheck(inputMonitorMap, invalidMap, monitorInfo);
        if (!validationFlag) {
            MessageView error = new MessageView(21091, "l7gui_Monitor", "Validation error.");
            session.setAttribute("resultMessage", (Object)error);
            session.setAttribute("inputMonitorData", (Object)monitorInfo);
            session.setAttribute("invalidMessage", invalidMap);
            response.sendRedirect("monitor_modify.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11494 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        CommandExecuter thread = new CommandExecuter(session);
        String button_mode = inputMonitorMap.get("button");
        if (button_mode != null && button_mode.equals("Save")) {
            mode = ExecuteMode.DIRECTOR_SAVE;
            redirectPage = "monitor_modify_executive.jsp";
        } else if (button_mode != null && button_mode.equals("Save + Sync")) {
            mode = ExecuteMode.DIRECTOR_SAVESYNC;
            redirectPage = "savesync_executive.jsp";
            SessionTransData trans = new SessionTransData();
            trans.sourceURI = "monitor_modify.jsp";
            trans.destURI = "monitor_info.jsp";
            trans.errorURI = "monitor_modify_fail.jsp";
            session.setAttribute("pageTrans", (Object)trans);
        } else {
            MessageView error = new MessageView(41214, "l7gui_Monitor", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11495 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        try {
            thread.setExecute(mode, monitorInfo);
            thread.start();
        }
        catch (Exception e) {
            MessageView error = new MessageView(41215, "l7gui_Monitor", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11496 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        response.sendRedirect(redirectPage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11497 MonitorServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected boolean validationCheck(HashMap<String, String> inputMonitorMap, HashMap<String, String> invalidMap, DirectorData monitorInfo) {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("MonitorSetServlet::validationCheck(HashMap<String, String> inputMonitorMap, HashMap<String, String> invalidMap, DirectorData monitorInfo) in ");
            buf.append("inputMonitorMap=(" + inputMonitorMap + "), ");
            buf.append("invalidMap=(" + invalidMap + "), ");
            buf.append("monitorInfo=(" + monitorInfo + ")");
            this.logger.debug((Object)("11498 " + buf.toString()));
        }
        boolean validationFrag = true;
        boolean MIN_CHECK_TIME_OUT = true;
        int MAX_CHECK_TIME_OUT = Integer.MAX_VALUE;
        boolean MIN_NEGOTIATE_TIME_OUT = true;
        int MAX_NEGOTIATE_TIME_OUT = Integer.MAX_VALUE;
        boolean MIN_CHECK_INTERVAL = true;
        int MAX_CHECK_INTERVAL = Integer.MAX_VALUE;
        boolean MIN_CHECK_COUNT = true;
        int MAX_CHECK_COUNT = Integer.MAX_VALUE;
        int CALLBACK_LENGTH = 127;
        int FALLBACK_LENGTH = 127;
        int LOGFILE_LENGTH = 127;
        int EXECUTE_LENGTH = 127;
        String checkTimeOut = inputMonitorMap.get("checkTimeOut");
        if (checkTimeOut != null && checkTimeOut.length() > 0) {
            int int_checkTimeOut = 0;
            try {
                int_checkTimeOut = Integer.parseInt(checkTimeOut);
                if (int_checkTimeOut < 1 || int_checkTimeOut > Integer.MAX_VALUE) {
                    invalidMap.put("checkTimeOut", "Invalid value.");
                    validationFrag = false;
                }
            }
            catch (NumberFormatException e) {
                invalidMap.put("checkTimeOut", "Invalid value.");
                validationFrag = false;
            }
        }
        monitorInfo.checkTimeOut = checkTimeOut;
        String negotiateTimeOut = inputMonitorMap.get("negotiateTimeOut");
        if (negotiateTimeOut != null && negotiateTimeOut.length() > 0) {
            int int_negotiateTimeOut = 0;
            try {
                int_negotiateTimeOut = Integer.parseInt(negotiateTimeOut);
                if (int_negotiateTimeOut < 1 || int_negotiateTimeOut > Integer.MAX_VALUE) {
                    invalidMap.put("negotiateTimeOut", "Invalid value.");
                    validationFrag = false;
                }
            }
            catch (NumberFormatException e) {
                invalidMap.put("negotiateTimeOut", "Invalid value.");
                validationFrag = false;
            }
        }
        monitorInfo.negotiateTimeOut = negotiateTimeOut;
        String checkInterval = inputMonitorMap.get("checkInterval");
        if (checkInterval != null && checkInterval.length() > 0) {
            int int_checkInterval = 0;
            try {
                int_checkInterval = Integer.parseInt(checkInterval);
                if (int_checkInterval < 1 || int_checkInterval > Integer.MAX_VALUE) {
                    invalidMap.put("checkInterval", "Invalid value.");
                    validationFrag = false;
                }
            }
            catch (NumberFormatException e) {
                invalidMap.put("checkInterval", "Invalid value.");
                validationFrag = false;
            }
        }
        monitorInfo.checkInterval = checkInterval;
        String checkCount = inputMonitorMap.get("checkCount");
        if (checkCount != null && checkCount.length() > 0) {
            int int_checkCount = 0;
            try {
                int_checkCount = Integer.parseInt(checkCount);
                if (int_checkCount < 1 || int_checkCount > Integer.MAX_VALUE) {
                    invalidMap.put("checkCount", "Invalid value.");
                    validationFrag = false;
                }
            }
            catch (NumberFormatException e) {
                invalidMap.put("checkCount", "Invalid value.");
                validationFrag = false;
            }
        }
        monitorInfo.checkCount = checkCount;
        String callback = inputMonitorMap.get("callback");
        if (callback != null && callback.length() > 0) {
            Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher = pattern.matcher(callback);
            if (callback.length() > 127 || matcher.find()) {
                invalidMap.put("callback", "Invalid value.");
                validationFrag = false;
            }
        }
        monitorInfo.callback = callback;
        String fallback = inputMonitorMap.get("fallback");
        if (fallback != null && fallback.length() > 0) {
            Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher = pattern.matcher(fallback);
            if (fallback.length() > 127 || matcher.find()) {
                invalidMap.put("fallback", "Invalid value.");
                validationFrag = false;
            }
        }
        monitorInfo.fallback = fallback;
        String logfile = inputMonitorMap.get("logfile");
        if (logfile != null && logfile.length() > 0) {
            Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher = pattern.matcher(logfile);
            if (logfile.length() > 127 || matcher.find()) {
                invalidMap.put("logfile", "Invalid value.");
                validationFrag = false;
            }
        }
        monitorInfo.logfile = logfile;
        String execute = inputMonitorMap.get("execute");
        if (execute != null && execute.length() > 0) {
            Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
            Matcher matcher = pattern.matcher(execute);
            if (execute.length() > 127 || matcher.find()) {
                invalidMap.put("execute", "Invalid value.");
                validationFrag = false;
            }
        }
        monitorInfo.execute = execute;
        String supervised = inputMonitorMap.get("supervised");
        if (supervised != null && supervised.length() > 0 && !supervised.equals("yes") && !supervised.equals("no")) {
            invalidMap.put("supervised", "Invalid value.");
            validationFrag = false;
        }
        monitorInfo.supervised = supervised;
        String quiescent = inputMonitorMap.get("quiescent");
        if (quiescent != null && quiescent.length() > 0 && !quiescent.equals("yes") && !quiescent.equals("no")) {
            invalidMap.put("quiescent", "Invalid value.");
            validationFrag = false;
        }
        monitorInfo.quiescent = quiescent;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("11499 MonitorSetServlet::validationCheck(HashMap<String, String> inputMonitorMap, HashMap<String, String> invalidMap, DirectorData monitorInfo) return=" + validationFrag));
        }
        return validationFrag;
    }
}

