#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

set -e

eval `ultrapossum-config init`
trap "eval `ultrapossum-config term`" 0

###########################################################################
# objectClass <attrName>
objectClass() {
  attributeName $1 | sed -e 's/^c$/country/' \
      -e 's/^dc$/dcObject/' -e 's/^o$/organization/'
}

# attributeName <attr>
attributeName() {
  echo $1 | cut -d= -f1
}

# attributeVal <attr>
attributeVal() {
  echo $1 | cut -d= -f2-
}

# attribute <dn>
attribute() {
  echo $1 | cut -d, -f1
}

each_dn() {
  for dn in `echo $1 | sed 's/,/ /'`
  do
    echo $dn
  done
}

topldif() {
  if test "x$o" != "xorganization"; then
    cat <<EOF
dn: $SUFFIX
objectClass: top
objectClass: $o
objectClass: organization
o: $ORGANIZATION
$key: $val
EOF
  else
  cat <<EOF
dn: $SUFFIX
objectClass: top
objectClass: $o
o: $val
EOF
  fi
}


###########################################################################

attr=`attribute $SUFFIX`
val=`attributeVal $attr`
key=`attributeName $attr`
o=`objectClass $key`
admin=$(attributeVal $(attribute $ROOTDN))
updatedn=$(attributeVal $(attribute $UPDATEDN))

topldif
echo ""

cat <<EOF
dn: $ROOTDN
objectClass: organizationalRole
cn: $admin
EOF

for a in $APPLICATIONS; do
  echo "roleOccupant: cn=$a,$SUFFIX"
done

echo ""
cat <<EOF
dn: ou=application,$SUFFIX
objectClass: organizationalUnit
ou: application
EOF

echo ""
cat <<EOF
dn: $UPDATEDN
objectClass: organizationalRole
objectClass: simpleSecurityObject
cn: $updatedn
userPassword: $CREDENTIALS
EOF

for s in $SUBORDINATES; do

  rdn=`echo $s | cut -d: -f1`
  url=`echo $s | cut -d: -f2-`
  rdn2=`attribute $rdn`
  rdnName=`attributeName $rdn2`
  rdnVal=`attributeVal $rdn2`

  cat <<EOF

dn: $rdn,$SUFFIX
objectClass: referral
objectClass: extensibleObject
$rdnName: $rdnVal
ref: $url$rdn,$SUFFIX
EOF

done

