#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# $Id: backup.sh,v 1.8 2004/04/20 09:49:30 taru Exp $

# backup.sh [<format>] -- format is one of ldif or tar

set -e

eval `ultrapossum-config init`
trap "eval `ultrapossum-config term`" 0

if test "x$SLAPD_VERSION" = "2.0"; then
  echo "E: can't backup when slapd $SLAPD_VERSION is running" 1>&2
  exit 1
fi

format=ldif
if test "x$1" != "x"; then
  format=$1
fi

install -d $BACKUPDIR

# create_file <method> <file (not gz)> <format>
create_file()
{
  if test -f "$2.gz"; then
    echo "W: $2.bz already exist" 1>&2
  else
    echo -n "Checking for $SUFFIX... "
    touch $2
    chmod 600 $2
    sh -c "$1" > $2
    echo "done"
    latest=`/bin/ls $BACKUPDIR/$SUFFIX-*$3.gz 2> /dev/null | sort -r | head -1`
    if test -f "$latest" && zcat $latest | diff -q - $2 > /dev/null; then
      echo -n "Sliding `basename $latest` to `basename $2.gz`... "
      /bin/rm $2
      /bin/mv $latest $2.gz
      echo "done"
    else
      echo -n "Backing up $SUFFIX... "
      gzip $2
      echo "done"
    fi
  fi
}


case "x$format" in
  xldif)
    backup=$BACKUPDIR/$SUFFIX-`date +%Y%m%d`.ldif
    create_file "slapcat -b $SUFFIX" "$backup" "$format"
  ;;
  xtar)
    backup=$BACKUPDIR/$SUFFIX-`date +%Y%m%d`.tar
    create_file "cd $DIRECTORY; tar cf - . " "$backup" "$format"
  ;;

  x*)
    echo "unknown format: $format" 1>&2
    exit 1
  ;;
esac
