/*
 * Decompiled with CFR 0.152.
 */
package ash.gui.core;

import ash.gui.core.AshBorderPanel;
import ash.gui.core.AshFileChooser;
import ash.gui.core.AshFont;
import ash.gui.core.AshGroupPanel;
import ash.gui.core.GUIAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AshPanel
extends JPanel {
    private ActionListener listener = GUIAdapter.getListener();
    protected EventObject eventObject;
    protected DocumentEvent docEvent;
    private boolean mediationStarted = false;
    private Set<Component> colleagues;
    private static final String MNEMONIC = "\\(([A-Z])\\)$";
    private static Pattern mnemonicPat = Pattern.compile("\\(([A-Z])\\)$");
    private int hgap = 2;
    private int vgap = 2;

    public AshPanel() {
    }

    public AshPanel(int n, int n2) {
        this(1, n, n2);
    }

    public AshPanel(int n, int n2, int n3) {
        this.setLayout(new FlowLayout(n, n2, n3));
    }

    protected void add(Component ... componentArray) {
        for (Component component : componentArray) {
            this.add(component);
        }
    }

    protected void setActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    protected void mediate(Component component) {
    }

    public void startMediation() {
        this.mediationStarted = true;
        this.mediate(null);
    }

    public void stopMediation() {
        this.mediationStarted = false;
    }

    protected void setColleagues(Component ... componentArray) {
        if (this.colleagues == null) {
            this.colleagues = new HashSet<Component>();
        }
        for (Component component : componentArray) {
            this.colleagues.add(component);
        }
    }

    protected void resetColleagues() {
        this.colleagues = null;
    }

    private void _mediate(Component component, EventObject eventObject) {
        this.eventObject = eventObject;
        this._mediate(component);
    }

    private void _mediate(Component component, DocumentEvent documentEvent) {
        this.docEvent = documentEvent;
        this._mediate(component);
    }

    private void _mediate(Component component) {
        if (this.mediationStarted && (this.colleagues == null || this.colleagues.contains(component))) {
            this.mediate(component);
        }
    }

    protected static Component convert(Object object) {
        if (object instanceof String) {
            return AshPanel.label((String)object);
        }
        return (Component)object;
    }

    protected static JLabel label(String string) {
        AshFont ashFont = new AshFont(string);
        JLabel jLabel = new JLabel(ashFont.getText());
        ashFont.setFont(jLabel);
        return jLabel;
    }

    protected AshButton button() {
        AshButton ashButton = new AshButton();
        ashButton.addActionListener(this.listener);
        return ashButton;
    }

    protected AshButton button(Icon icon) {
        AshButton ashButton = this.button();
        ashButton.setIcon(icon);
        return ashButton;
    }

    protected AshButton button(String string) {
        AshFont ashFont = new AshFont(string);
        string = ashFont.getText();
        AshButton ashButton = this.button();
        ashButton.setText(string);
        AshPanel.setMnemonic(ashButton, string);
        ashFont.setFont(ashButton);
        return ashButton;
    }

    protected AshButton button(String string, String string2) {
        AshButton ashButton = this.button(string);
        ashButton.setActionCommand(string2);
        return ashButton;
    }

    protected AshButton button(String string, boolean bl) {
        AshButton ashButton = this.button(string);
        ashButton.setEnabled(bl);
        return ashButton;
    }

    protected AshButton button(String string, String string2, boolean bl) {
        AshButton ashButton = this.button(string, string2);
        ashButton.setEnabled(bl);
        return ashButton;
    }

    protected AshCheckBox check() {
        return new AshCheckBox();
    }

    protected AshCheckBox check(String string) {
        AshCheckBox ashCheckBox = this.check();
        ashCheckBox.setText(string);
        AshPanel.setMnemonic(ashCheckBox, string);
        return ashCheckBox;
    }

    protected AshCheckBox check(String string, boolean bl) {
        AshCheckBox ashCheckBox = this.check(string);
        ashCheckBox.setSelected(bl);
        return ashCheckBox;
    }

    protected AshCheckBox check(String string, String string2, boolean bl) {
        AshCheckBox ashCheckBox = this.check(string, bl);
        ashCheckBox.setActionCommand(string2);
        ashCheckBox.addActionListener(this.listener);
        return ashCheckBox;
    }

    protected AshRadio radio() {
        return new AshRadio();
    }

    protected AshRadio radio(boolean bl) {
        AshRadio ashRadio = this.radio();
        ashRadio.setSelected(bl);
        return ashRadio;
    }

    protected AshRadio radio(String string) {
        AshRadio ashRadio = this.radio();
        ashRadio.setText(string);
        AshPanel.setMnemonic(ashRadio, string);
        return ashRadio;
    }

    protected AshRadio radio(String string, boolean bl) {
        AshRadio ashRadio = this.radio(string);
        ashRadio.setSelected(bl);
        return ashRadio;
    }

    protected AshRadio radio(String string, String string2, boolean bl) {
        AshRadio ashRadio = this.radio(string, bl);
        ashRadio.setActionCommand(string2);
        ashRadio.addActionListener(this.listener);
        return ashRadio;
    }

    protected static void groupButtons(AbstractButton ... abstractButtonArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (AbstractButton abstractButton : abstractButtonArray) {
            buttonGroup.add(abstractButton);
        }
    }

    protected AshComboBox combobox() {
        return new AshComboBox();
    }

    protected AshComboBox combobox(Object[] objectArray) {
        return new AshComboBox(objectArray);
    }

    protected AshList listbox() {
        return new AshList();
    }

    protected AshList listbox(Object[] objectArray) {
        return new AshList(objectArray);
    }

    protected AshFileChooser fchooser(String string, int n) {
        return this.chooser(string, n, 'f');
    }

    protected AshFileChooser dchooser(String string, int n) {
        return this.chooser(string, n, 'd');
    }

    private AshFileChooser chooser(String string, int n, char c) {
        AshFont ashFont = new AshFont(string);
        AshFileChooser ashFileChooser = new AshFileChooser(ashFont.getText(), n, c);
        ashFont.setFont(ashFileChooser.getField());
        return ashFileChooser;
    }

    protected AshField field() {
        return new AshField();
    }

    protected AshField field(String string) {
        AshFont ashFont = new AshFont(string);
        AshField ashField = this.field();
        ashField.setText(ashFont.getText());
        ashFont.setFont(ashField);
        return ashField;
    }

    protected AshField field(int n) {
        AshField ashField = this.field();
        ashField.setColumns(n);
        return ashField;
    }

    protected AshField field(String string, int n) {
        AshField ashField = this.field(string);
        ashField.setColumns(n);
        return ashField;
    }

    protected AshPassword password() {
        return new AshPassword();
    }

    protected AshPassword password(String string) {
        AshFont ashFont = new AshFont(string);
        AshPassword ashPassword = this.password();
        ashPassword.setText(ashFont.getText());
        ashFont.setFont(ashPassword);
        return ashPassword;
    }

    protected AshPassword password(int n) {
        AshPassword ashPassword = this.password();
        ashPassword.setColumns(n);
        return ashPassword;
    }

    protected AshPassword password(String string, int n) {
        AshPassword ashPassword = this.password(string);
        ashPassword.setColumns(n);
        return ashPassword;
    }

    protected JTextArea textarea(int n, int n2) {
        return this.textarea(n, n2, AshFont.getFont());
    }

    protected JTextArea textarea(int n, int n2, String string) {
        AshFont ashFont = new AshFont(string);
        return this.textarea(n, n2, ashFont.getTextFont());
    }

    protected JTextArea textarea(int n, int n2, Font font) {
        JTextArea jTextArea = new JTextArea(n, n2);
        jTextArea.setFont(font);
        jTextArea.setTabSize(4);
        jTextArea.setLineWrap(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.height -= 64;
        dimension.width -= 64;
        jTextArea.setMaximumSize(dimension);
        return jTextArea;
    }

    private static int getMnemonic(String string) {
        Matcher matcher = mnemonicPat.matcher(string);
        return matcher.find() ? (int)matcher.group(1).charAt(0) : 0;
    }

    public static void setMnemonic(AbstractButton abstractButton, String string) {
        int n = AshPanel.getMnemonic(string);
        if (n != 0) {
            abstractButton.setMnemonic(n);
        }
    }

    protected JPanel flowL(Object ... objectArray) {
        return this.flowLG(this.hgap, objectArray);
    }

    protected JPanel flowLG(int n, Object ... objectArray) {
        JPanel jPanel = new JPanel(new FlowLayout(0, n, this.vgap));
        return AshPanel.addComponents(jPanel, objectArray);
    }

    protected JPanel flowC(Object ... objectArray) {
        return this.flowCG(this.hgap, objectArray);
    }

    protected JPanel flowCG(int n, Object ... objectArray) {
        JPanel jPanel = new JPanel(new FlowLayout(1, n, this.vgap));
        return AshPanel.addComponents(jPanel, objectArray);
    }

    protected JPanel flowR(Object ... objectArray) {
        return this.flowRG(this.hgap, objectArray);
    }

    protected JPanel flowRG(int n, Object ... objectArray) {
        JPanel jPanel = new JPanel(new FlowLayout(2, n, this.vgap));
        return AshPanel.addComponents(jPanel, objectArray);
    }

    protected void setHgap(int n) {
        this.hgap = n;
    }

    protected void setVgap(int n) {
        this.vgap = n;
    }

    public static JPanel grid(int n, int n2, Object ... objectArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(n, n2));
        return AshPanel.addComponents(jPanel, objectArray);
    }

    private static JPanel addComponents(JPanel jPanel, Object ... objectArray) {
        for (Object object : objectArray) {
            jPanel.add(AshPanel.convert(object));
        }
        return jPanel;
    }

    protected static Box boxH(Object ... objectArray) {
        return AshPanel.boxHA(0.0f, objectArray);
    }

    protected static Box boxHA(float f, Object ... objectArray) {
        Box box = Box.createHorizontalBox();
        for (Object object : objectArray) {
            JComponent jComponent;
            if (object instanceof JComponent) {
                jComponent = (JComponent)object;
                jComponent.setAlignmentY(f);
                box.add(jComponent);
                continue;
            }
            if (object instanceof String) {
                jComponent = AshPanel.label((String)object);
                jComponent.setAlignmentY(f);
                box.add(jComponent);
                continue;
            }
            if (object instanceof Glue) {
                box.add(Box.createHorizontalGlue());
                continue;
            }
            if (object instanceof Strut) {
                box.add(Box.createHorizontalStrut(((Strut)object).size));
                continue;
            }
            if (object instanceof Rigid) {
                box.add(Box.createRigidArea((Rigid)object));
                continue;
            }
            throw new RuntimeException("ERROR: boxH: " + object);
        }
        return box;
    }

    protected static Box boxV(Object ... objectArray) {
        return AshPanel.boxVA(0.0f, objectArray);
    }

    protected static Box boxVA(float f, Object ... objectArray) {
        Box box = Box.createVerticalBox();
        for (Object object : objectArray) {
            JComponent jComponent;
            if (object instanceof JComponent) {
                jComponent = (JComponent)object;
                jComponent.setAlignmentX(f);
                box.add(jComponent);
                continue;
            }
            if (object instanceof String) {
                jComponent = AshPanel.label((String)object);
                jComponent.setAlignmentX(f);
                box.add(jComponent);
                continue;
            }
            if (object instanceof Glue) {
                box.add(Box.createVerticalGlue());
                continue;
            }
            if (object instanceof Strut) {
                box.add(Box.createVerticalStrut(((Strut)object).size));
                continue;
            }
            if (object instanceof Rigid) {
                box.add(Box.createRigidArea((Rigid)object));
                continue;
            }
            throw new RuntimeException("ERROR: boxV: " + object);
        }
        return box;
    }

    public static Glue glue() {
        return new Glue();
    }

    public static Strut strut(int n) {
        return new Strut(n);
    }

    public static Rigid rigid(int n, int n2) {
        return new Rigid(n, n2);
    }

    protected static AshGroupPanel group(int n, int n2, Object ... objectArray) {
        return new AshGroupPanel(n, n2).form(objectArray);
    }

    protected static List<Object> line(Object ... objectArray) {
        return AshPanel.sg(objectArray);
    }

    protected static List<Object> sg(Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (object instanceof String) {
                object = AshPanel.label((String)object);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    protected static Gap gap(int n) {
        return new Gap(n, n, n);
    }

    protected static Gap gap(int n, int n2, int n3) {
        return new Gap(n, n2, n3);
    }

    public static AshBorderPanel panel(Component component) {
        return AshPanel.panel().setNorth(AshPanel.panel().setWest(component));
    }

    public static AshBorderPanel centerEast(Object object, Object object2) {
        return AshPanel.panel().setCenter(object).setEast(object2);
    }

    public static AshBorderPanel westCenter(Object object, Object object2) {
        return AshPanel.panel().setWest(object).setCenter(object2);
    }

    public static AshBorderPanel northCenter(Object object, Object object2) {
        return AshPanel.panel().setNorth(object).setCenter(object2);
    }

    public static AshBorderPanel centerSouth(Object object, Object object2) {
        return AshPanel.panel().setCenter(object).setSouth(object2);
    }

    private static AshBorderPanel panel() {
        return new AshBorderPanel();
    }

    public static AshBorderPanel pane(Object ... objectArray) {
        int n = objectArray.length;
        if (n == 0) {
            return AshPanel.panel();
        }
        if (n == 1) {
            return AshPanel.pane(new Object[0]).setCenter(objectArray[0]);
        }
        if (n == 2) {
            return AshPanel.northCenter(objectArray[0], objectArray[1]);
        }
        return AshPanel.northCenter(objectArray[0], AshPanel.pane(AshPanel.shift(objectArray)));
    }

    private static Object[] shift(Object[] objectArray) {
        return Arrays.copyOfRange(objectArray, 1, objectArray.length);
    }

    public static JScrollPane scroll(Component component) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(component);
        jScrollPane.setEnabled(true);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        return jScrollPane;
    }

    public static JComponent splitH(boolean bl, int n, JComponent jComponent, JComponent jComponent2) {
        JSplitPane jSplitPane = new JSplitPane(1, jComponent, jComponent2);
        jSplitPane.setOneTouchExpandable(bl);
        jSplitPane.setResizeWeight((double)n / 100.0);
        return jSplitPane;
    }

    public static JComponent splitV(boolean bl, int n, JComponent jComponent, JComponent jComponent2) {
        JSplitPane jSplitPane = new JSplitPane(0, jComponent, jComponent2);
        jSplitPane.setOneTouchExpandable(bl);
        jSplitPane.setResizeWeight((double)n / 100.0);
        return jSplitPane;
    }

    public static JComponent border(int n, int n2, int n3, int n4, JComponent jComponent) {
        jComponent.setBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4));
        return jComponent;
    }

    public static JComponent border(JComponent jComponent) {
        jComponent.setBorder(BorderFactory.createEtchedBorder(0));
        return jComponent;
    }

    public static JComponent border(JComponent jComponent, Color color) {
        jComponent.setBorder(BorderFactory.createLineBorder(color));
        return jComponent;
    }

    public static JComponent border(String string, JComponent jComponent) {
        AshFont ashFont = new AshFont(string);
        Border border = BorderFactory.createEtchedBorder(0);
        jComponent.setBorder(BorderFactory.createTitledBorder(border, ashFont.getText(), 0, 0, ashFont.getTextFont()));
        return jComponent;
    }

    protected static JComponent border(String string, JComponent jComponent, Color color) {
        AshFont ashFont = new AshFont(string);
        Border border = BorderFactory.createLineBorder(color);
        jComponent.setBorder(BorderFactory.createTitledBorder(border, ashFont.getText(), 0, 0, ashFont.getTextFont()));
        return jComponent;
    }

    public static class Gap {
        int min;
        int pref;
        int max;

        public Gap(int n, int n2, int n3) {
            this.min = n;
            this.pref = n2;
            this.max = n3;
        }

        public void addTo(GroupLayout.Group group) {
            group.addGap(this.min, this.pref, this.max);
        }

        public String toString() {
            if (this.min == this.max) {
                return "Gap[" + this.min + "]";
            }
            return "Gap[" + this.min + ", " + this.pref + ", " + this.max + "]";
        }
    }

    public static class Rigid
    extends Dimension {
        public Rigid(int n, int n2) {
            super(n, n2);
        }
    }

    public static class Strut {
        int size;

        public Strut(int n) {
            this.size = n;
        }
    }

    public static class Glue {
    }

    protected class AshPassword
    extends JPasswordField
    implements DocumentListener {
        public AshPassword() {
            this.getDocument().addDocumentListener(this);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.setBackground(bl ? Color.white : Color.lightGray);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            AshPanel.this._mediate(this, documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            AshPanel.this._mediate(this, documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            AshPanel.this._mediate(this, documentEvent);
        }
    }

    protected class AshField
    extends JTextField
    implements DocumentListener {
        public AshField() {
            this.getDocument().addDocumentListener(this);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.setBackground(bl ? Color.white : Color.lightGray);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            AshPanel.this._mediate(this, documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            AshPanel.this._mediate(this, documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            System.err.println("==> AshField#changedUpdate()");
        }

        public int getInt() {
            return Integer.parseInt(this.getText());
        }
    }

    protected class AshList
    extends JList
    implements ListSelectionListener {
        AshList() {
            this.addListSelectionListener(this);
        }

        AshList(Object[] objectArray) {
            this();
            this.setListData(objectArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AshPanel.this._mediate(this, listSelectionEvent);
        }
    }

    protected class AshComboBox
    extends JComboBox
    implements ItemListener {
        AshComboBox() {
            this.addItemListener(this);
        }

        AshComboBox(Object[] objectArray) {
            this();
            for (Object object : objectArray) {
                this.addItem(object);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            AshPanel.this._mediate(this, itemEvent);
        }
    }

    protected class AshRadio
    extends JRadioButton
    implements ItemListener {
        public AshRadio() {
            this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            AshPanel.this._mediate(this, itemEvent);
        }
    }

    protected class AshCheckBox
    extends JCheckBox
    implements ItemListener {
        public AshCheckBox() {
            this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            AshPanel.this._mediate(this, itemEvent);
        }
    }

    protected class AshButton
    extends JButton
    implements ActionListener {
        public AshButton() {
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AshPanel.this._mediate(this, actionEvent);
        }
    }
}

