/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.struct;

import ash.reverse.parser.Mod;
import ash.reverse.parser.Visibility;
import ash.reverse.struct.GroupRecord;
import ash.reverse.struct.ObjectVisitor;
import java.util.ArrayList;
import java.util.List;

public abstract class ObjectRecord {
    static final String SEP = "\t";
    GroupRecord owner;
    String type;
    String name = "";
    int loc = 0;
    int startLine;
    int endLine;
    String signature;
    Visibility visibility;
    int modifiers;
    static final char SPACEHOLDER = '+';
    private List<String> tokens = new ArrayList<String>();

    public GroupRecord owner() {
        return this.owner;
    }

    public String type() {
        return this.type;
    }

    public void type(String string) {
        this.type = string;
    }

    public String name() {
        return this.name;
    }

    public void name(String string) {
        this.name = string;
    }

    public String signature() {
        return this.signature;
    }

    public Visibility visibility() {
        return this.visibility;
    }

    public void visibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isPublic() {
        return this.visibility == Visibility.PUBLIC;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public void modifiers(int n) {
        this.modifiers = n;
    }

    public boolean isAbstract() {
        return Mod.ABSTRACT.in(this.modifiers);
    }

    public boolean isInterface() {
        return false;
    }

    public ObjectRecord root() {
        return this.owner != null ? this.owner.root() : this;
    }

    public String fqcn() {
        if (this.owner == null) {
            return this.name;
        }
        String string = this.owner.fqcn();
        if (string == null || string.isEmpty()) {
            return this.name;
        }
        return this.owner.fqcn() + "." + this.name;
    }

    ObjectRecord(String string, String string2, int n, GroupRecord groupRecord) {
        this.type = string;
        this.name = string2;
        this.startLine = n;
        this.owner = groupRecord;
    }

    public void addLoc(int n) {
        this.loc += n;
    }

    public void setLineEnd(int n) {
        this.endLine = n;
    }

    protected int countMethods() {
        return 0;
    }

    protected int sumMethodLoc() {
        return 0;
    }

    public String toString() {
        return this.type + " " + this.name + " " + this.loc;
    }

    public String errMessage() {
        return this.type + " " + this.name + " at line " + this.startLine;
    }

    public void setSignature(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n3 = string.charAt(i);
            if (n > 0 && n3 == 32) {
                if (n2 == 44 || n2 == 60 || n2 == 62 || n2 == 43) continue;
                n3 = 43;
            }
            stringBuilder.append((char)n3);
            if (n3 == 60) {
                ++n;
            }
            if (n3 == 62) {
                --n;
            }
            n2 = n3;
        }
        this.signature = stringBuilder.toString();
        this.paraseDecl(this.signature);
    }

    public String getSignature() {
        int n = this.signature.lastIndexOf(9);
        return n < 0 ? this.signature : this.signature.substring(n + 1);
    }

    protected void paraseDecl(String string) {
        String[] stringArray = this.extractDecl(string).split("[\\s(]");
        String string2 = "null";
        for (String string3 : stringArray) {
            if (string3.equals(this.name)) {
                this.type = string2;
                continue;
            }
            if (Mod.mask(string3) != 0 || !Visibility.undef(string3)) continue;
            string2 = string3;
        }
    }

    private String extractDecl(String string) {
        int n;
        int n2 = string.lastIndexOf(9);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        if ((n = string.indexOf(40)) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public void addToken(String string) {
        this.tokens.add(string);
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public abstract void accept(ObjectVisitor var1);

    boolean trace(Object object) {
        System.err.println(object);
        return true;
    }
}

