/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.uml;

import ash.reverse.struct.ClassRecord;
import ash.reverse.struct.ClassVisitor;
import ash.reverse.struct.FieldRecord;
import ash.reverse.struct.FileRecord;
import ash.reverse.struct.MethodRecord;
import ash.reverse.struct.ObjectRecord;
import ash.reverse.uml.Assoc;
import ash.reverse.uml.ClassNode;
import ash.reverse.uml.Depends;
import ash.reverse.uml.Extends;
import ash.reverse.uml.InnerRel;
import ash.reverse.uml.MethodNode;
import ash.reverse.uml.Relationship;
import ash.reverse.uml.UMLConst;
import ash.reverse.uml.UMLDiagram;
import java.awt.Font;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClsGenerator
extends UMLDiagram {
    private int selectLevel;
    private boolean aflag;
    private boolean bflag;
    private Map<String, Integer> packageMap;
    private Map<String, ClassRecord> fqcnMap;
    private Map<Integer, ClassNode> idMap;
    private FileRecord theFile;
    private ClassRecord theClassRec;
    private ClassNode theClassNode;
    private int packageID;
    private List<ClassRecord> interfaceList = new ArrayList<ClassRecord>();
    private Map<ClassRecord, Depends> theRefMap = new HashMap<ClassRecord, Depends>();
    static final String MULTIPLICITY = "(List|ArrayList|LinkedList|Set|HashSet|TreeSet)<(\\w+)>";
    static final Pattern MULTI_PAT = Pattern.compile("(List|ArrayList|LinkedList|Set|HashSet|TreeSet)<(\\w+)>");
    static final String TYPE_DECL = "(\\w+).*";
    static final Pattern TYPE_PAT = Pattern.compile("(\\w+).*");

    public static void generate(PrintStream printStream, List<FileRecord> list, Font font, int n, boolean bl, boolean bl2) {
        ClsGenerator clsGenerator = new ClsGenerator();
        clsGenerator.setFont(font);
        clsGenerator.setParams(n, bl, bl2);
        clsGenerator.generateClassInfo(list);
        clsGenerator.generateHeader(printStream);
        clsGenerator.generateDiagram(printStream);
    }

    void setParams(int n, boolean bl, boolean bl2) {
        this.selectLevel = n;
        this.aflag = bl;
        this.bflag = bl2;
    }

    void generateClassInfo(List<FileRecord> list) {
        this.packageMap = this.makePackageMap(list);
        this.fqcnMap = new ClassVisitor(list).fqcnMap();
        this.idMap = new HashMap<Integer, ClassNode>();
        this.nodeList = new ArrayList();
        this.relList = new ArrayList();
        for (FileRecord object2 : list) {
            this.genFile(object2);
        }
        for (Relationship relationship : this.relList) {
            if (!(relationship instanceof Assoc)) continue;
            Object object = (Assoc)relationship;
            ((Assoc)object).setRecursiveNode(this.idMap);
        }
        HashSet hashSet = new HashSet();
        for (Object object : this.relList) {
            if (!(object instanceof Assoc)) continue;
            hashSet.add(((Relationship)object).linkID());
        }
        ArrayList<Relationship> arrayList = new ArrayList<Relationship>();
        for (Relationship relationship : this.relList) {
            if (!(relationship instanceof Depends) || !hashSet.contains(relationship.linkID())) continue;
            arrayList.add(relationship);
        }
        this.relList.removeAll(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    Map<String, Integer> makePackageMap(List<FileRecord> list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (FileRecord object2 : list) {
            String string = object2.pkgname();
            if (string.isEmpty()) continue;
            treeSet.add(string);
        }
        TreeSet treeSet2 = new TreeSet();
        for (FileRecord fileRecord : list) {
            for (String string : fileRecord.onDemandSet()) {
                treeSet2.add(string);
            }
            for (String string : fileRecord.typePkgMap().values()) {
                treeSet2.add(string);
            }
        }
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        boolean bl = false;
        for (String string : treeSet) {
            void var5_11;
            linkedHashMap.put(string, (int)(++var5_11));
        }
        Iterator<String> iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            void var5_12;
            String string;
            string = iterator.next();
            if (linkedHashMap.containsKey(string)) continue;
            linkedHashMap.put(string, (int)(++var5_12));
        }
        return linkedHashMap;
    }

    void generateHeader(PrintStream printStream) {
        for (String object : this.fqcnMap.keySet()) {
            ClassRecord classRecord = this.fqcnMap.get(object);
            printStream.println("# " + classRecord.id() + ". " + object);
        }
        printStream.println();
        for (Map.Entry entry : this.packageMap.entrySet()) {
            printStream.println("PACKAGE\t" + entry.getValue() + "\t" + (String)entry.getKey());
        }
        if (!this.packageMap.isEmpty()) {
            printStream.println();
        }
    }

    private void genFile(FileRecord fileRecord) {
        this.theFile = fileRecord;
        String string = fileRecord.pkgname();
        this.packageID = string.isEmpty() ? 0 : this.packageMap.get(string);
        for (ObjectRecord objectRecord : fileRecord.members()) {
            this.genClass((ClassRecord)objectRecord);
        }
    }

    private void genClass(ClassRecord classRecord) {
        Object object;
        Iterator<Object> iterator;
        this.theClassRec = classRecord;
        this.theClassNode = new ClassNode(classRecord.name(), this.classFormat(classRecord), this.packageID);
        this.idMap.put(classRecord.id(), this.theClassNode);
        this.nodeList.add(this.theClassNode);
        this.theClassNode.setFontMetrics(this.fm);
        this.theRefMap.clear();
        this.interfaceList.clear();
        if (classRecord.superClass() != null && (iterator = this.findType(classRecord, classRecord.superClass())) != null) {
            this.relList.add(new Extends(classRecord.id(), ((ClassRecord)((Object)iterator)).id(), null));
        }
        for (String object2 : classRecord.interfaces()) {
            object = this.findType(classRecord, object2);
            if (object == null) continue;
            this.relList.add(new Extends(classRecord.id(), ((ClassRecord)object).id(), null));
            this.interfaceList.add((ClassRecord)object);
        }
        if (this.selectLevel > 0) {
            for (String string : classRecord.enumList()) {
                object = "ATTRIB\t" + string + "\t" + "$EnumValue" + "\t" + "null";
                this.theClassNode.addAttribute(string, (String)object, 0);
            }
        }
        for (ObjectRecord objectRecord : classRecord.members()) {
            if (objectRecord instanceof ClassRecord) {
                object = (ClassRecord)objectRecord;
                this.genClass((ClassRecord)object);
                this.relList.add(new InnerRel(((ClassRecord)object).id(), classRecord.id(), null));
                continue;
            }
            if (objectRecord instanceof FieldRecord) {
                this.genField((FieldRecord)objectRecord);
                continue;
            }
            this.genMethod((MethodRecord)objectRecord);
        }
    }

    private void genMethod(MethodRecord methodRecord) {
        String string;
        String string2 = methodRecord.getSignature();
        if (string2.indexOf(34) >= 0) {
            return;
        }
        int n = string2.indexOf(40);
        int n2 = string2.lastIndexOf(41);
        if (n < 0 || n2 < 0) {
            return;
        }
        String string3 = string2.substring(0, n);
        if (this.aflag) {
            this.addRefFromAPI(methodRecord, methodRecord.type(), UMLConst.Stereotype.RETURN);
        }
        MethodNode methodNode = null;
        if (methodRecord.visibility().level() <= this.selectLevel) {
            methodNode = new MethodNode(methodRecord.name(), this.memberFormat("METHOD", methodRecord), this.findPackageID(methodRecord.type()));
            this.theClassNode.addMethod(methodNode);
        }
        if (!(string = string2.substring(n + 1, n2)).isEmpty()) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split(", ");
            int n3 = stringArray2.length;
            for (int i = 0; i < n3; ++i) {
                String string4;
                String string5 = string4 = stringArray2[i];
                String string6 = "null";
                for (String string7 : string4.split(" ")) {
                    string6 = string5;
                    string5 = string7;
                }
                if (methodNode != null) {
                    methodNode.addParam(string5, "PARAM\t" + string5 + "\t" + string6, this.findPackageID(string6));
                }
                if (!this.aflag) continue;
                this.addRefFromAPI(methodRecord, string6, UMLConst.Stereotype.PARAM);
            }
        }
        if (this.bflag) {
            this.parseBodyToken(methodRecord);
        }
    }

    private void genField(FieldRecord fieldRecord) {
        if (this.bflag) {
            this.parseBodyToken(fieldRecord);
        }
        ClassRecord classRecord = (ClassRecord)fieldRecord.owner();
        String string = fieldRecord.signature();
        ClassRecord classRecord2 = this.findType(fieldRecord, fieldRecord.type());
        if (classRecord2 != null) {
            Assoc assoc = new Assoc(classRecord.id(), classRecord2.id(), null);
            assoc.setTarget("0..1", true, fieldRecord.name());
            this.relList.add(assoc);
            return;
        }
        Matcher matcher = MULTI_PAT.matcher(fieldRecord.type());
        if (matcher.find() && (classRecord2 = this.findType(fieldRecord, matcher.group(2))) != null) {
            Assoc assoc = new Assoc(classRecord.id(), classRecord2.id(), null);
            assoc.setTarget("*", true, fieldRecord.name());
            this.relList.add(assoc);
            return;
        }
        if (fieldRecord.visibility().level() <= this.selectLevel) {
            this.theClassNode.addAttribute(fieldRecord.name(), this.memberFormat("ATTRIB", fieldRecord), 0);
        }
    }

    private int findPackageID(String string) {
        String string2;
        Integer n;
        Matcher matcher = TYPE_PAT.matcher(string);
        if (matcher.find() && (n = this.packageMap.get(string2 = this.theFile.getPackage(matcher.group(1)))) != null) {
            return n;
        }
        return 0;
    }

    private void addRefFromAPI(MethodRecord methodRecord, String string, UMLConst.Stereotype stereotype) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("[<>,+]")) {
            this.addDepends(methodRecord, string2, stereotype);
        }
    }

    private void parseBodyToken(ObjectRecord objectRecord) {
        UMLConst.Stereotype stereotype = UMLConst.Stereotype.BODY;
        for (String string : objectRecord.getTokens()) {
            this.addDepends(objectRecord, string, stereotype);
            stereotype = UMLConst.Stereotype.value(string);
            if (stereotype == UMLConst.Stereotype.NEW) continue;
            stereotype = UMLConst.Stereotype.BODY;
        }
    }

    private void addDepends(ObjectRecord objectRecord, String string, UMLConst.Stereotype stereotype) {
        ClassRecord classRecord = this.fqcnMap.get(string);
        if (classRecord != null) {
            this.addTarget(classRecord, string, stereotype);
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\.")) {
                classRecord = this.findType(objectRecord, string2);
                if (classRecord == null) continue;
                this.addTarget(classRecord, string2, stereotype);
            }
        }
    }

    private void addTarget(ClassRecord classRecord, String string, UMLConst.Stereotype stereotype) {
        assert (this.trace(stereotype.label + " " + string));
        Depends depends = this.theRefMap.get(classRecord);
        if (depends == null) {
            depends = new Depends(this.theClassRec.id(), classRecord.id(), stereotype);
            this.relList.add(depends);
            this.theRefMap.put(classRecord, depends);
        } else {
            depends.count(stereotype);
        }
    }

    private ClassRecord findType(ObjectRecord objectRecord, String string) {
        ClassRecord classRecord = this.fqcnMap.get(string);
        if (classRecord != null) {
            return classRecord;
        }
        classRecord = objectRecord.owner().findType(string);
        if (classRecord != null) {
            return classRecord;
        }
        classRecord = this.findInterfaceType(string);
        if (classRecord != null) {
            return classRecord;
        }
        FileRecord fileRecord = (FileRecord)objectRecord.root();
        classRecord = this.fqcnMap.get(fileRecord.fqcn(string));
        if (classRecord != null) {
            return classRecord;
        }
        classRecord = this.fqcnMap.get(fileRecord.pkgname() + "." + string);
        if (classRecord != null) {
            return classRecord;
        }
        return classRecord;
    }

    private ClassRecord findInterfaceType(String string) {
        for (ClassRecord classRecord : this.interfaceList) {
            ClassRecord classRecord2 = classRecord.findType(string);
            if (classRecord2 == null) continue;
            return classRecord2;
        }
        return null;
    }

    String classFormat(ClassRecord classRecord) {
        String string = classRecord.type().toUpperCase();
        if (classRecord.isAbstract()) {
            string = "@" + string;
        }
        return string + "\t" + classRecord.id() + "\t" + classRecord.name() + "\t" + (Object)((Object)classRecord.visibility());
    }

    String memberFormat(String string, ObjectRecord objectRecord) {
        if (objectRecord.isAbstract()) {
            string = "@" + string;
        }
        return string + "\t" + objectRecord.name() + "\t" + objectRecord.type() + "\t" + (Object)((Object)objectRecord.visibility());
    }

    @Override
    boolean trace(Object object) {
        System.err.println(object);
        return true;
    }
}

