/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.gui;

import java.awt.Point;
import java.awt.event.MouseEvent;
import pbl2011.common.CommonConst;
import pbl2011.common.Util;
import pbl2011.gui.MouseEditState;
import pbl2011.gui.UMLCanvas;
import pbl2011.model.AssociationArc;
import pbl2011.model.ClassNode;
import pbl2011.model.NodeArcSet;

class ArcDrawState
extends MouseEditState {
    private ClassNode orgNode;
    protected CommonConst.AssocType kind;

    public ArcDrawState(UMLCanvas uMLCanvas, ClassNode classNode, CommonConst.AssocType assocType) {
        super(uMLCanvas, null);
        this.orgNode = classNode;
        this.kind = assocType;
        if (classNode != null) {
            this.currPt = new Point(classNode.p.x + classNode.width / 2, classNode.p.y + classNode.height() / 2);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = Util.adjust(mouseEvent.getPoint());
        this.UMLView.setCurrPoint(this.currPt, point);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        ClassNode classNode = this.UMLView.selectClass(point);
        this.UMLView.setCurrPoint(null, null);
        if (classNode != null && !classNode.equals(this.orgNode)) {
            AssociationArc associationArc = this.UMLView.addNewArc(this.orgNode, classNode, this.kind);
            NodeArcSet nodeArcSet = new NodeArcSet();
            nodeArcSet.add(associationArc);
            nodeArcSet.setCreateFlg(true);
            this.UMLView.getModel().undoredoModel.tryPush(nodeArcSet);
        }
    }
}

