/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import pbl2011.model.AssociationArc;
import pbl2011.model.ClassNode;
import pbl2011.model.NodeArcSet;

public class UndoRedoModel {
    private List<ClassNode> classNodeList = new ArrayList<ClassNode>();
    private List<AssociationArc> associationArcList = new ArrayList<AssociationArc>();
    private List<NodeArcSet> nodearcSetList = new ArrayList<NodeArcSet>();
    protected UndoManager undoManager = new UndoManager();

    public void initializeUndoRedoModel() {
        this.classNodeList = new ArrayList<ClassNode>();
        this.associationArcList = new ArrayList<AssociationArc>();
        this.nodearcSetList = new ArrayList<NodeArcSet>();
        this.undoManager = new UndoManager();
    }

    public List<ClassNode> getClassNodeList() {
        return this.classNodeList;
    }

    public List<AssociationArc> getAssociationArcList() {
        return this.associationArcList;
    }

    public List<NodeArcSet> getNodeArcSetList() {
        return this.nodearcSetList;
    }

    public ClassNode getNodeLatest() {
        return this.classNodeList.get(this.classNodeList.size() - 1);
    }

    public AssociationArc getArcLatest() {
        return this.associationArcList.get(this.associationArcList.size() - 1);
    }

    public NodeArcSet getNodeArcSetLatest() {
        return this.nodearcSetList.get(this.nodearcSetList.size() - 1);
    }

    public boolean tryPush(NodeArcSet nodeArcSet) {
        NodeArcSet nodeArcSet2 = new NodeArcSet();
        if (nodeArcSet == null) {
            return false;
        }
        if (nodeArcSet.isCreate()) {
            nodeArcSet2.setCreateFlg(true);
        }
        for (ClassNode commonConst : nodeArcSet.classNodeList) {
            if (commonConst == null) continue;
            ClassNode classNode = commonConst.clone();
            if (nodeArcSet2.isCreate()) {
                classNode.undoredoModel.classNodeList.clear();
            }
            if (classNode.undoredoModel.classNodeList.size() > 0 && classNode.equals(commonConst.undoredoModel.getNodeLatest())) continue;
            if (classNode.undoredoModel.classNodeList.size() != 0 || nodeArcSet2.isCreate()) {
                nodeArcSet2.add(classNode);
            }
            classNode.undoredoModel.classNodeList.add(classNode);
            classNode.undoredoModel.undoManager.undoableEditHappened(new UndoableEditEvent(this, new ClassUndoRedoAbleModel(classNode, classNode.undoredoModel.getClassNodeList())));
        }
        for (AssociationArc associationArc : nodeArcSet.associationArcList) {
            if (associationArc == null) continue;
            AssociationArc associationArc2 = associationArc.clone();
            if (nodeArcSet2.isCreate()) {
                associationArc2.undoredoModel.associationArcList.clear();
            }
            if (associationArc2.undoredoModel.associationArcList.size() > 0 && associationArc2.equals(associationArc2.undoredoModel.getArcLatest())) continue;
            if (associationArc2.undoredoModel.associationArcList.size() != 0 || nodeArcSet2.isCreate()) {
                nodeArcSet2.add(associationArc2);
            }
            associationArc2.undoredoModel.associationArcList.add(associationArc2);
            associationArc2.undoredoModel.undoManager.undoableEditHappened(new UndoableEditEvent(this, new ArcUndoRedoAbleModel(associationArc2, associationArc2.undoredoModel.getAssociationArcList())));
        }
        if (!nodeArcSet2.isEmpty()) {
            this.nodearcSetList.add(nodeArcSet2);
            this.undoManager.undoableEditHappened(new UndoableEditEvent(this, new UndoRedoAbleModel(nodeArcSet2, this.nodearcSetList)));
            return true;
        }
        return false;
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void undoAction() {
        try {
            this.undoManager.undo();
        }
        catch (CannotRedoException cannotRedoException) {
            cannotRedoException.printStackTrace();
        }
    }

    public void redoAction() {
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            cannotRedoException.printStackTrace();
        }
    }

    class UndoRedoAbleModel
    extends AbstractUndoableEdit {
        protected List<NodeArcSet> nodearcSetList;
        protected NodeArcSet nodearcSet;

        public UndoRedoAbleModel(NodeArcSet nodeArcSet, List<NodeArcSet> list) {
            this.nodearcSetList = list;
            this.nodearcSet = nodeArcSet;
        }

        @Override
        public String getPresentationName() {
            return "Class and Arc Undo/Redo";
        }

        @Override
        public void undo() {
            super.undo();
            this.nodearcSetList.remove(this.nodearcSetList.size() - 1);
        }

        @Override
        public void redo() {
            super.redo();
            this.nodearcSetList.add(this.nodearcSet);
        }
    }

    class ArcUndoRedoAbleModel
    extends AbstractUndoableEdit {
        protected List<AssociationArc> associationArcList;
        protected AssociationArc associationArc;

        public ArcUndoRedoAbleModel(AssociationArc associationArc, List<AssociationArc> list) {
            this.associationArcList = list;
            this.associationArc = associationArc;
        }

        @Override
        public String getPresentationName() {
            return "Arc Undo/Redo";
        }

        @Override
        public void undo() {
            super.undo();
            this.associationArcList.remove(this.associationArcList.size() - 1);
        }

        @Override
        public void redo() {
            super.redo();
            this.associationArcList.add(this.associationArc);
        }
    }

    class ClassUndoRedoAbleModel
    extends AbstractUndoableEdit {
        protected List<ClassNode> classNodeList;
        protected ClassNode classNode;

        public ClassUndoRedoAbleModel(ClassNode classNode, List<ClassNode> list) {
            this.classNodeList = list;
            this.classNode = classNode;
        }

        @Override
        public String getPresentationName() {
            return "Class Undo/Redo";
        }

        @Override
        public void undo() {
            super.undo();
            this.classNodeList.remove(this.classNodeList.size() - 1);
        }

        @Override
        public void redo() {
            super.redo();
            this.classNodeList.add(this.classNode);
        }
    }
}

