/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.common;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import pbl2011.common.CommonConst;

public class Util
implements CommonConst {
    private static final String REG_EX_JAVA_SPECIFIC_SYMBOL = ".*[\\[\\]\\<,\\>\\.+].*";

    public static int[] calcArrowPoint(Point point, Point point2) {
        double d = Math.atan2(point2.y - point.y, point2.x - point.x);
        double d2 = 0.39269908169872414;
        int n = (int)(10.0 * Math.cos(d + d2));
        int n2 = (int)(10.0 * Math.sin(d + d2));
        int n3 = (int)(10.0 * Math.cos(d - d2));
        int n4 = (int)(10.0 * Math.sin(d - d2));
        return new int[]{point.x + n, point.y + n2, point.x + n3, point.y + n4};
    }

    public static int[] calcTrianglePoint(Point point, Point point2) {
        double d = Math.atan2(point2.y - point.y, point2.x - point.x);
        double d2 = 0.5235987755982988;
        int n = (int)(12.0 * Math.cos(d + d2));
        int n2 = (int)(12.0 * Math.sin(d + d2));
        int n3 = (int)(12.0 * Math.cos(d - d2));
        int n4 = (int)(12.0 * Math.sin(d - d2));
        return new int[]{point.x + n, point.y + n2, point.x + n3, point.y + n4};
    }

    public static Point calcCrossPoint(Rectangle rectangle, Point point) {
        int n;
        if (rectangle.contains(point)) {
            return null;
        }
        int n2 = rectangle.width / 2;
        int n3 = point.x - (rectangle.x + rectangle.width / 2);
        int n4 = rectangle.y + rectangle.height / 2 - point.y;
        int n5 = n3 == 0 ? 0 : n4 * n2 / n3;
        if (n3 != 0 && n5 <= rectangle.height / 2) {
            if (point.x > rectangle.x) {
                n = rectangle.y + rectangle.height / 2 - n5;
                if (n >= rectangle.y && n <= rectangle.y + rectangle.height) {
                    return new Point(rectangle.x + rectangle.width, n);
                }
            } else {
                n = rectangle.y + rectangle.height / 2 + n5;
                if (n >= rectangle.y && n <= rectangle.y + rectangle.height) {
                    return new Point(rectangle.x, n);
                }
            }
        }
        if ((n5 = (n4 = rectangle.x + rectangle.width / 2 - point.x) * (n2 = rectangle.height / 2) / (n3 = point.y - (rectangle.y + rectangle.height / 2))) <= rectangle.width / 2) {
            if (point.y > rectangle.y) {
                n = rectangle.x + rectangle.width / 2 - n5;
                if (n >= rectangle.x && n <= rectangle.x + rectangle.width) {
                    return new Point(n, rectangle.y + rectangle.height);
                }
            } else {
                n = rectangle.x + rectangle.width / 2 + n5;
                if (n >= rectangle.x && n <= rectangle.x + rectangle.width) {
                    return new Point(n, rectangle.y);
                }
            }
        }
        return null;
    }

    public static Point[] calcRightAngleHPoint(Rectangle rectangle, Rectangle rectangle2) {
        boolean bl;
        Rectangle rectangle3;
        Rectangle rectangle4;
        if (rectangle.intersects(rectangle2)) {
            return null;
        }
        if (rectangle.x <= rectangle2.x) {
            rectangle4 = rectangle;
            rectangle3 = rectangle2;
            bl = true;
        } else {
            rectangle4 = rectangle2;
            rectangle3 = rectangle;
            bl = false;
        }
        if (rectangle4.x + rectangle4.width >= rectangle3.x) {
            Rectangle rectangle5;
            Rectangle rectangle6;
            if (rectangle.y <= rectangle2.y) {
                rectangle6 = rectangle;
                rectangle5 = rectangle2;
                bl = true;
            } else {
                rectangle6 = rectangle2;
                rectangle5 = rectangle;
                bl = false;
            }
            return Util.putUpAndDown(rectangle6, rectangle5, bl);
        }
        return Util.putRightAndLeft(rectangle4, rectangle3, bl);
    }

    public static Point[] calcRightAngleVPoint(Rectangle rectangle, Rectangle rectangle2) {
        boolean bl;
        Rectangle rectangle3;
        Rectangle rectangle4;
        if (rectangle.intersects(rectangle2)) {
            return null;
        }
        if (rectangle.y <= rectangle2.y) {
            rectangle4 = rectangle;
            rectangle3 = rectangle2;
            bl = true;
        } else {
            rectangle4 = rectangle2;
            rectangle3 = rectangle;
            bl = false;
        }
        if (rectangle4.y + rectangle4.height >= rectangle3.y) {
            Rectangle rectangle5;
            Rectangle rectangle6;
            if (rectangle.x <= rectangle2.x) {
                rectangle6 = rectangle;
                rectangle5 = rectangle2;
                bl = true;
            } else {
                rectangle6 = rectangle2;
                rectangle5 = rectangle;
                bl = false;
            }
            return Util.putRightAndLeft(rectangle6, rectangle5, bl);
        }
        return Util.putUpAndDown(rectangle4, rectangle3, bl);
    }

    private static Point[] putUpAndDown(Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        int n = (rectangle2.y - (rectangle.y + rectangle.height)) / 2 + (rectangle.y + rectangle.height);
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
        Point point2 = new Point(rectangle.x + rectangle.width / 2, n);
        Point point3 = new Point(rectangle2.x + rectangle2.width / 2, n);
        Point point4 = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y);
        if (bl) {
            return new Point[]{point, point2, point3, point4};
        }
        return new Point[]{point4, point3, point2, point};
    }

    private static Point[] putRightAndLeft(Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        int n = (rectangle2.x - (rectangle.x + rectangle.width)) / 2 + (rectangle.x + rectangle.width);
        Point point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
        Point point2 = new Point(n, rectangle.y + rectangle.height / 2);
        Point point3 = new Point(n, rectangle2.y + rectangle2.height / 2);
        Point point4 = new Point(rectangle2.x, rectangle2.y + rectangle2.height / 2);
        if (bl) {
            return new Point[]{point, point2, point3, point4};
        }
        return new Point[]{point4, point3, point2, point};
    }

    public static Point adjust(Point point) {
        return new Point(Util.adjust(point.x), Util.adjust(point.y));
    }

    public static int adjust(int n) {
        return Util.adjust(n, 8);
    }

    public static int adjust(int n, int n2) {
        return (n + n2 / 2) / n2 * n2;
    }

    public static boolean debug(String string) {
        System.err.println(string);
        return true;
    }

    public static boolean hasSymbol(String string) {
        return string.matches(REG_EX_JAVA_SPECIFIC_SYMBOL);
    }

    public static Integer removeSymbol(String string) {
        String string2 = string;
        string2 = string2.replace("\\[.*\\]", "");
        string2 = string2.replace("\\<.*\\>", "");
        string2 = string2.replace("\\.+", "");
        return Integer.valueOf(string2);
    }

    public static List<String> getTypeList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string.replace(" ", "");
        if (Util.hasSymbol(string2)) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split("[\\[\\]\\<,\\>\\.+]")) {
                if ("".equals(string3)) continue;
                arrayList.add(string3);
            }
        } else {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = clazz.getClassLoader();
        }
        return classLoader;
    }
}

