/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import pbl2011.common.CommonConst;
import pbl2011.common.Util;
import pbl2011.gui.ArcDrawState;
import pbl2011.gui.ChangeClassColorListener;
import pbl2011.gui.FrameMoveState;
import pbl2011.gui.FrameResizeState;
import pbl2011.gui.ModelSelectState;
import pbl2011.gui.MouseEditState;
import pbl2011.gui.PointMoveState;
import pbl2011.gui.State;
import pbl2011.gui.UMLCanvas;
import pbl2011.model.AssociationArc;
import pbl2011.model.ClassNode;
import pbl2011.model.NodeArcSet;
import pbl2011.model.UndoRedoModel;
import pbl2011.mvc.Controller;
import pbl2011.mvc.View;

public class UMLCanvasController
extends Controller
implements MouseListener {
    private UMLCanvas UMLView;
    public UndoRedoModel undoredoModel;
    private JColorChooser colorChooser;
    MouseEditState state;
    JPopupMenu popClass;
    JPopupMenu popArc;
    JMenuItem addPoint;
    JMenuItem delPoint;
    Point popPoint;

    public UMLCanvasController(View view) {
        super(view);
        this.UMLView = (UMLCanvas)view;
        this.createPopMenue();
        this.undoredoModel = view.getModel().undoredoModel;
        this.colorChooser = new JColorChooser();
    }

    @Override
    public void update() {
        NodeArcSet nodeArcSet = new NodeArcSet();
        for (ClassNode commonConst : this.myModel.getAllActiveClassData()) {
            nodeArcSet.add(commonConst);
        }
        for (AssociationArc associationArc : this.myModel.getAllActiveAssociationArc()) {
            nodeArcSet.add(associationArc);
        }
        this.undoredoModel.tryPush(nodeArcSet);
        this.myView.update();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("MODIFY_CLASS_COLOR".equals(string)) {
            this.executeChangeClassColor();
        } else if ("MODIFY_PACKAGE_COLOR".equals(string)) {
            this.executeChangePackageColor();
        } else if ("DEL_CLASS".equals(string)) {
            this.executeClassDelete();
        } else if ("DEL_ARC".equals(string)) {
            this.executeArcDelete();
        } else if ("RIGHT_ANGLE".equals(string)) {
            this.executeLine(CommonConst.AssocLineType.RIGHT_ANGLE);
        } else if ("RIGHT_ANGLE_H".equals(string)) {
            this.executeLine(CommonConst.AssocLineType.RIGHT_ANGLE_H);
        } else if ("STRAIGHT_LINE".equals(string)) {
            this.executeLine(CommonConst.AssocLineType.STRAIGHT_LINE);
        } else if ("FREE_LINE".equals(string)) {
            this.executeLine(CommonConst.AssocLineType.FREE_LINE);
        } else if ("ADD_POINT".equals(string)) {
            this.executeAddPoint();
        } else if ("DEL_POINT".equals(string)) {
            this.executeDelPoint();
        }
    }

    protected ArrayList<ClassNode> executeChangeClassColor() {
        ClassNode classNode = this.cuMgr.getCurrentNode();
        ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
        arrayList.add(classNode);
        ChangeClassColorListener changeClassColorListener = new ChangeClassColorListener(this, arrayList, this.colorChooser);
        JDialog jDialog = JColorChooser.createDialog(this.UMLView, "Select Color", true, this.colorChooser, changeClassColorListener, null);
        jDialog.setVisible(true);
        return arrayList;
    }

    protected ArrayList<ClassNode> executeChangePackageColor() {
        ClassNode classNode = this.cuMgr.getCurrentNode();
        ArrayList<ClassNode> arrayList = this.UMLView.getModel().getAllActiveClassData();
        ArrayList<ClassNode> arrayList2 = new ArrayList<ClassNode>();
        for (ClassNode object2 : arrayList) {
            if (classNode.getPackageName() != null && object2.getPackageName() != null) {
                if (!classNode.getPackageName().equals(object2.getPackageName())) continue;
                arrayList2.add(object2);
                continue;
            }
            if (classNode.getPackageName() != null || object2.getPackageName() != null) continue;
            arrayList2.add(object2);
        }
        ChangeClassColorListener changeClassColorListener = new ChangeClassColorListener(this, arrayList2, this.colorChooser);
        JDialog jDialog = JColorChooser.createDialog(this.UMLView, "Select Color", true, this.colorChooser, changeClassColorListener, null);
        jDialog.setVisible(true);
        return arrayList2;
    }

    protected void executeClassDelete() {
        this.myModel.deleteClass();
    }

    protected void executeArcDelete() {
        NodeArcSet nodeArcSet = new NodeArcSet();
        AssociationArc associationArc = this.cuMgr.getCurrentArc();
        associationArc.delFlag = true;
        nodeArcSet.add(associationArc);
        this.undoredoModel.tryPush(nodeArcSet);
        this.cuMgr.setCurrentArc(null);
        this.myModel.changeModel();
    }

    protected void executeLine(CommonConst.AssocLineType assocLineType) {
        AssociationArc associationArc = this.cuMgr.getCurrentArc();
        associationArc.pointList = assocLineType.isFREE_LINE() ? this.UMLView.getArcPointList(associationArc) : null;
        associationArc.lineStyle = assocLineType;
        NodeArcSet nodeArcSet = new NodeArcSet();
        nodeArcSet.add(associationArc);
        this.undoredoModel.tryPush(nodeArcSet);
        this.myModel.changeModel();
    }

    protected void executeAddPoint() {
        this.UMLView.addArcPoint(this.popPoint);
        this.myModel.changeModel();
    }

    protected int executeDelPoint() {
        int n = this.pointClickCheck(this.popPoint);
        if (n > -1) {
            this.UMLView.delArcPoint(n);
            this.myModel.changeModel();
        }
        return n;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
        Point point = Util.adjust(mouseEvent.getPoint());
        int n = -1;
        ClassNode classNode = this.UMLView.selectClass(point);
        AssociationArc associationArc = this.UMLView.selectArc(mouseEvent.getPoint());
        if (State.arcSelect != null && classNode == null) {
            State.changeToSelectMode();
        }
        if (State.classSelect) {
            if (!this.UMLView.mainCanvas) {
                return;
            }
            assert (Util.debug("UMLView.classSelect"));
            this.state = new FrameMoveState(this.UMLView, point);
            this.cuMgr.setCurrentNode(this.UMLView.addNewClass(point));
            NodeArcSet nodeArcSet = new NodeArcSet();
            nodeArcSet.add(this.cuMgr.getCurrentNode());
            nodeArcSet.setCreateFlg(true);
            this.undoredoModel.tryPush(nodeArcSet);
            this.clearClassAddMode();
        } else if (State.arcSelect != null) {
            if (!this.UMLView.mainCanvas) {
                return;
            }
            if (classNode != null) {
                assert (Util.debug("UMLView.arcSelect"));
                this.state = new ArcDrawState(this.UMLView, classNode, State.arcSelect);
                NodeArcSet nodeArcSet = new NodeArcSet();
                nodeArcSet.add(this.cuMgr.getCurrentArc());
                nodeArcSet.setCreateFlg(true);
                this.undoredoModel.tryPush(nodeArcSet);
            } else {
                this.cuMgr.setCurrentNode(null);
                this.cuMgr.setCurrentArc(null);
            }
        } else if (this.cuMgr.getCurrentNodeList().size() > 1 && this.UMLView.selectClass(point, this.cuMgr.getCurrentNodeList()) != null) {
            this.state = new FrameMoveState(this.UMLView, point);
        } else if (this.cuMgr.getCurrentNodeList().size() == 1) {
            if (this.UMLView.mainCanvas) {
                Point point2 = this.knobClickCheck1(point);
                if (point2 != null) {
                    this.state = new FrameResizeState(this.UMLView, point2, point, 1);
                } else {
                    point2 = this.knobClickCheck2(point);
                    if (point2 != null) {
                        this.state = new FrameResizeState(this.UMLView, point2, point, 2);
                    } else {
                        point2 = this.knobClickCheck3(point);
                        if (point2 != null) {
                            this.state = new FrameResizeState(this.UMLView, point2, point, 3);
                        } else if (classNode != null) {
                            this.cuMgr.setCurrentNode(classNode);
                            this.state = new FrameMoveState(this.UMLView, point);
                        } else if (associationArc != null) {
                            this.cuMgr.setCurrentArc(associationArc);
                        } else {
                            this.cuMgr.setCurrentNode(null);
                            this.cuMgr.setCurrentArc(null);
                            this.state = new ModelSelectState(this.UMLView, point);
                        }
                    }
                }
            } else if (classNode != null) {
                this.cuMgr.setCurrentNode(classNode);
                this.state = new FrameMoveState(this.UMLView, point);
            } else {
                this.cuMgr.setCurrentNode(null);
                this.cuMgr.setCurrentArc(null);
            }
        } else if (this.cuMgr.getCurrentArc() != null && (n = this.pointClickCheck(point)) > -1) {
            this.state = new PointMoveState(this.UMLView, point, n);
            n = -1;
        } else if (classNode != null) {
            this.cuMgr.setCurrentNode(classNode);
            this.state = new FrameMoveState(this.UMLView, point);
        } else if (associationArc != null) {
            this.cuMgr.setCurrentArc(associationArc);
        } else {
            this.cuMgr.setCurrentNode(null);
            this.cuMgr.setCurrentArc(null);
            this.state = new ModelSelectState(this.UMLView, point);
        }
        this.UMLView.repaint();
    }

    protected void clearClassAddMode() {
        State.changeToSelectMode();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.state instanceof FrameMoveState) {
            this.state = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.state == null) {
            return;
        }
        this.state.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
        if (this.state == null) {
            return;
        }
        if (this.cuMgr.getCurrentNode() != null) {
            NodeArcSet nodeArcSet = new NodeArcSet();
            ArrayList<AssociationArc> arrayList = this.myModel.getAllActiveAssociationArc();
            ClassNode classNode = this.cuMgr.getCurrentNode();
            nodeArcSet.add(classNode);
            for (AssociationArc associationArc : arrayList) {
                if (associationArc.classIdTarget != classNode.classId && associationArc.classIdSource != classNode.classId) continue;
                nodeArcSet.add(associationArc);
            }
            this.undoredoModel.tryPush(nodeArcSet);
        }
        this.state.mouseReleased(mouseEvent);
        this.myModel.changeModel();
    }

    private void createPopMenue() {
        this.popClass = new JPopupMenu();
        this.popArc = new JPopupMenu();
        JMenu jMenu = new JMenu("\u8272\u306e\u5909\u66f4");
        JMenuItem jMenuItem = new JMenuItem("\u30af\u30e9\u30b9\u8272");
        jMenuItem.setActionCommand("MODIFY_CLASS_COLOR");
        jMenuItem.addActionListener(this);
        JMenuItem jMenuItem2 = new JMenuItem("\u30d1\u30c3\u30b1\u30fc\u30b8\u8272");
        jMenuItem2.setActionCommand("MODIFY_PACKAGE_COLOR");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        this.popClass.add(jMenu);
        JMenuItem jMenuItem3 = new JMenuItem("\u524a\u9664");
        jMenuItem3.setActionCommand("DEL_CLASS");
        jMenuItem3.addActionListener(this);
        this.popClass.add(jMenuItem3);
        JMenu jMenu2 = new JMenu("\u76f4\u89d2\u306b\u3059\u308b");
        JMenuItem jMenuItem4 = new JMenuItem("\u7e26\u512a\u5148");
        jMenuItem4.setActionCommand("RIGHT_ANGLE");
        jMenuItem4.addActionListener(this);
        JMenuItem jMenuItem5 = new JMenuItem("\u6a2a\u512a\u5148");
        jMenuItem5.setActionCommand("RIGHT_ANGLE_H");
        jMenuItem5.addActionListener(this);
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("\u76f4\u7dda\u306b\u3059\u308b");
        jMenuItem6.setActionCommand("STRAIGHT_LINE");
        jMenuItem6.addActionListener(this);
        JMenuItem jMenuItem7 = new JMenuItem("\u81ea\u7531\u306b\u3064\u306a\u3050");
        jMenuItem7.setActionCommand("FREE_LINE");
        jMenuItem7.addActionListener(this);
        this.addPoint = new JMenuItem("\u9802\u70b9\u3092\u8ffd\u52a0");
        this.addPoint.setActionCommand("ADD_POINT");
        this.addPoint.addActionListener(this);
        this.delPoint = new JMenuItem("\u9802\u70b9\u3092\u524a\u9664");
        this.delPoint.setActionCommand("DEL_POINT");
        this.delPoint.addActionListener(this);
        JMenuItem jMenuItem8 = new JMenuItem("\u524a\u9664");
        jMenuItem8.setActionCommand("DEL_ARC");
        jMenuItem8.addActionListener(this);
        this.popArc.add(jMenuItem6);
        this.popArc.add(jMenu2);
        this.popArc.add(jMenuItem7);
        this.popArc.add(this.addPoint);
        this.popArc.add(this.delPoint);
        this.popArc.add(jMenuItem8);
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popPoint = mouseEvent.getPoint();
            if (this.cuMgr.getCurrentNode() != null && this.cuMgr.getCurrentNode().equals(this.UMLView.selectClass(this.popPoint))) {
                this.popClass.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (this.cuMgr.getCurrentArc() != null && this.cuMgr.getCurrentArc().equals(this.UMLView.selectArc(this.popPoint))) {
                this.addPoint.setEnabled(false);
                this.delPoint.setEnabled(false);
                if (this.cuMgr.getCurrentArc().lineStyle.isFREE_LINE()) {
                    this.addPoint.setEnabled(true);
                    if (this.cuMgr.getCurrentArc().pointList.length > 2) {
                        this.delPoint.setEnabled(true);
                    }
                }
                this.popArc.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private Point knobClickCheck1(Point point) {
        ClassNode classNode = this.cuMgr.getCurrentNode();
        assert (Util.debug("knobClickCheck1"));
        if (this.hitKnob(point, classNode.p.x, classNode.p.y)) {
            return new Point(classNode.p.x + classNode.width, classNode.p.y + classNode.height1);
        }
        if (this.hitKnob(point, classNode.p.x, classNode.p.y + classNode.height1)) {
            return new Point(classNode.p.x + classNode.width, classNode.p.y);
        }
        if (this.hitKnob(point, classNode.p.x + classNode.width, classNode.p.y)) {
            return new Point(classNode.p.x, classNode.p.y + classNode.height1);
        }
        if (this.hitKnob(point, classNode.p.x + classNode.width, classNode.p.y + classNode.height1)) {
            return new Point(classNode.p.x, classNode.p.y);
        }
        return null;
    }

    private Point knobClickCheck2(Point point) {
        ClassNode classNode = this.cuMgr.getCurrentNode();
        assert (Util.debug("knobClickCheck2"));
        if (this.hitKnob(point, classNode.p.x, classNode.p.y + classNode.height1 + classNode.height2)) {
            return new Point(classNode.p.x + classNode.width, classNode.p.y + classNode.height1);
        }
        if (this.hitKnob(point, classNode.p.x + classNode.width, classNode.p.y + classNode.height1 + classNode.height2)) {
            return new Point(classNode.p.x, classNode.p.y + classNode.height1);
        }
        return null;
    }

    private Point knobClickCheck3(Point point) {
        ClassNode classNode = this.cuMgr.getCurrentNode();
        assert (Util.debug("knobClickCheck3"));
        if (this.hitKnob(point, classNode.p.x, classNode.p.y + classNode.height())) {
            return new Point(classNode.p.x + classNode.width, classNode.p.y + classNode.height1 + classNode.height2);
        }
        if (this.hitKnob(point, classNode.p.x + classNode.width, classNode.p.y + classNode.height())) {
            return new Point(classNode.p.x, classNode.p.y + classNode.height1 + classNode.height2);
        }
        return null;
    }

    private boolean hitKnob(Point point, int n, int n2) {
        int n3 = 6;
        Rectangle rectangle = new Rectangle(n - n3 / 2, n2 - n3 / 2, n3, n3);
        return rectangle.contains(point);
    }

    private int pointClickCheck(Point point) {
        AssociationArc associationArc = this.cuMgr.getCurrentArc();
        if (associationArc != null && associationArc.lineStyle.isFREE_LINE()) {
            Point[] pointArray = associationArc.pointList;
            for (int i = 0; i < pointArray.length; ++i) {
                if (!this.hitPoint(point, pointArray[i].x, pointArray[i].y)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean hitPoint(Point point, int n, int n2) {
        int n3 = 8;
        Rectangle rectangle = new Rectangle(n - n3 / 2, n2 - n3 / 2, n3, n3);
        return rectangle.contains(point);
    }
}

