/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.mvc;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import pbl2011.common.CommonConst;
import pbl2011.gui.State;
import pbl2011.model.AssociationArc;
import pbl2011.model.ClassNode;
import pbl2011.model.NodeArcSet;
import pbl2011.mvc.Model;

public class CurrentManager
implements CommonConst {
    public Model model;
    protected AssociationArc currentArc;
    private Point sPoint;
    private Point ePoint;
    private ArrayList<ClassNode> selectedClasses;
    protected ArrayList<ClassNode> clipBoardC;
    protected ArrayList<AssociationArc> clipBoardA;

    public CurrentManager(Model model) {
        this.model = model;
        this.selectedClasses = new ArrayList();
        this.clipBoardC = new ArrayList();
        this.clipBoardA = new ArrayList();
    }

    public ClassNode getCurrentNode() {
        if (this.selectedClasses.size() == 1) {
            return this.selectedClasses.get(0);
        }
        return null;
    }

    public void setCurrentNode(ClassNode classNode) {
        this.selectedClasses.clear();
        this.selectedClasses.add(classNode);
        this.currentArc = null;
        this.model.changeModel();
    }

    public AssociationArc getCurrentArc() {
        return this.currentArc;
    }

    public void setCurrentArc(AssociationArc associationArc) {
        this.currentArc = associationArc;
        this.selectedClasses.clear();
        this.model.changeModel();
    }

    public void clear() {
        this.currentArc = null;
        this.selectedClasses.clear();
    }

    public void setStartPoint(Point point) {
        this.clear();
        this.sPoint = point;
        this.ePoint = point;
    }

    public void setEndPoint(Point point) {
        this.ePoint = point;
    }

    public Rectangle getSelectRect() {
        return this.calcRect(this.sPoint, this.ePoint);
    }

    public void selectStatus() {
        if (this.sPoint == null || this.ePoint == null) {
            return;
        }
        Rectangle rectangle = this.calcRect(this.sPoint, this.ePoint);
        ArrayList<ClassNode> arrayList = this.model.getAllActiveClassData();
        ArrayList<ClassNode> arrayList2 = new ArrayList<ClassNode>();
        for (ClassNode classNode : arrayList) {
            if (!rectangle.contains(classNode.getRectangle())) continue;
            arrayList2.add(classNode);
        }
        this.addCurrentClasses(arrayList2);
        this.sPoint = null;
        this.ePoint = null;
    }

    private Rectangle calcRect(Point point, Point point2) {
        int n;
        int n2;
        int n3;
        int n4;
        if (point == null || point2 == null) {
            return null;
        }
        if (point2.x > point.x) {
            n4 = point2.x - point.x;
            n3 = point.x;
        } else {
            n4 = point.x - point2.x;
            n3 = point2.x;
        }
        if (point2.y > point.y) {
            n2 = point2.y - point.y;
            n = point.y;
        } else {
            n2 = point.y - point2.y;
            n = point2.y;
        }
        return new Rectangle(n3, n, n4, n2);
    }

    public ArrayList<ClassNode> getCurrentNodeList() {
        return this.selectedClasses;
    }

    public void addCurrentClasses(ArrayList<ClassNode> arrayList) {
        this.selectedClasses.addAll(arrayList);
        this.model.changeModel();
    }

    public void addCurrentClasses(ClassNode classNode) {
        this.selectedClasses.add(classNode);
        this.model.changeModel();
    }

    public void copy() {
        CommonConst commonConst;
        this.clipBoardC.clear();
        this.clipBoardA.clear();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (ClassNode iterator : this.getCurrentNodeList()) {
            int associationArc = this.model.getNextClassId();
            hashMap.put(iterator.classId, associationArc);
            commonConst = iterator.clone();
            ((ClassNode)commonConst).classId = associationArc;
            ((ClassNode)commonConst).clearUndoRedoModel();
            this.clipBoardC.add((ClassNode)commonConst);
        }
        ArrayList arrayList = new ArrayList();
        for (ClassNode classNode : this.selectedClasses) {
            arrayList.add(classNode.classId);
        }
        for (AssociationArc associationArc : this.model.getAllActiveAssociationArc()) {
            if (!arrayList.contains(associationArc.classIdSource) || !arrayList.contains(associationArc.classIdTarget)) continue;
            commonConst = associationArc.clone();
            ((AssociationArc)commonConst).classIdSource = (Integer)hashMap.get(associationArc.classIdSource);
            ((AssociationArc)commonConst).classIdTarget = (Integer)hashMap.get(associationArc.classIdTarget);
            ((AssociationArc)commonConst).clearUndoRedoModel();
            this.clipBoardA.add((AssociationArc)commonConst);
        }
    }

    public void paste() {
        this.clear();
        NodeArcSet nodeArcSet = new NodeArcSet();
        nodeArcSet.setCreateFlg(true);
        for (ClassNode commonConst : this.clipBoardC) {
            commonConst.moveDelta(48, 48, State.width, State.height);
        }
        this.addCurrentClasses(this.clipBoardC);
        this.model.addClass(this.clipBoardC);
        if (this.clipBoardC instanceof ArrayList) {
            for (ClassNode classNode : this.clipBoardC) {
                nodeArcSet.add(classNode);
            }
        }
        this.clipBoardC.clear();
        this.model.addAssociation(this.clipBoardA);
        if (this.clipBoardA instanceof ArrayList) {
            for (AssociationArc associationArc : this.clipBoardA) {
                nodeArcSet.add(associationArc);
            }
        }
        this.clipBoardA.clear();
        this.model.undoredoModel.tryPush(nodeArcSet);
    }

    public void cut() {
        this.copy();
        this.model.deleteClass();
    }

    public void undo() {
        boolean bl = false;
        if (this.model.undoredoModel.canUndo()) {
            bl = this.model.undoredoModel.getNodeArcSetLatest().isCreate();
            for (ClassNode commonConst : this.model.undoredoModel.getNodeArcSetLatest().classNodeList) {
                if (commonConst.undoredoModel.canUndo()) {
                    if (bl) {
                        this.model.removeClassById(commonConst.undoredoModel.getNodeLatest());
                    }
                    commonConst.undoredoModel.undoAction();
                }
                if (!commonConst.undoredoModel.canUndo() || bl) continue;
                this.model.setClassDataById(commonConst.undoredoModel.getNodeLatest());
            }
            for (AssociationArc associationArc : this.model.undoredoModel.getNodeArcSetLatest().associationArcList) {
                if (associationArc.undoredoModel.canUndo()) {
                    if (bl) {
                        this.model.removeArcById(associationArc.undoredoModel.getArcLatest());
                    }
                    associationArc.undoredoModel.undoAction();
                }
                if (!associationArc.undoredoModel.canUndo() || bl) continue;
                this.model.setArcDataById(associationArc.undoredoModel.getArcLatest());
            }
            this.model.undoredoModel.undoAction();
        }
        this.clear();
        this.model.changeModel();
    }

    public void redo() {
        boolean bl = false;
        if (this.model.undoredoModel.canRedo()) {
            this.model.undoredoModel.redoAction();
            bl = this.model.undoredoModel.getNodeArcSetLatest().isCreate();
            for (ClassNode commonConst : this.model.undoredoModel.getNodeArcSetLatest().classNodeList) {
                if (!commonConst.undoredoModel.canRedo()) continue;
                commonConst.undoredoModel.redoAction();
                if (bl) {
                    this.model.addClass(commonConst.undoredoModel.getNodeLatest().clone());
                    continue;
                }
                this.model.setClassDataById(commonConst.undoredoModel.getNodeLatest());
            }
            for (AssociationArc associationArc : this.model.undoredoModel.getNodeArcSetLatest().associationArcList) {
                if (!associationArc.undoredoModel.canRedo()) continue;
                associationArc.undoredoModel.redoAction();
                if (bl) {
                    this.model.addAssociation(associationArc.undoredoModel.getArcLatest().clone());
                    continue;
                }
                this.model.setArcDataById(associationArc.undoredoModel.getArcLatest());
            }
        }
        this.clear();
        this.model.changeModel();
    }
}

