/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.struct;

import ash.reverse.parser.JavaType;
import ash.reverse.struct.GroupRecord;
import ash.reverse.struct.MethodRecord;
import ash.reverse.struct.ObjectRecord;
import ash.reverse.struct.ObjectVisitor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ClassRecord
extends GroupRecord {
    private String superClass;
    private List<String> interfaces = new ArrayList<String>();
    private List<String> enumList = new ArrayList<String>();
    private int id;
    private JavaType jtype;
    private MethodRecord theMethod;

    public String superClass() {
        return this.superClass;
    }

    public List<String> interfaces() {
        return this.interfaces;
    }

    public int id() {
        return this.id;
    }

    public void id(int n) {
        this.id = n;
    }

    public boolean isEnum() {
        return this.jtype == JavaType.ENUM;
    }

    @Override
    public boolean isInterface() {
        return this.jtype == JavaType.INTERFACE;
    }

    public String symbol() {
        return this.jtype.symbol();
    }

    public List<String> enumList() {
        return this.enumList;
    }

    public void addEnum(String string) {
        this.enumList.add(string);
    }

    public String qcn() {
        String string = this.name;
        GroupRecord groupRecord = this.owner;
        while (groupRecord instanceof ClassRecord) {
            string = ((ClassRecord)groupRecord).name + "." + string;
            groupRecord = groupRecord.owner;
        }
        return string;
    }

    public ClassRecord(String string, String string2, int n, GroupRecord groupRecord) {
        super(string, string2, n, groupRecord);
        this.jtype = JavaType.value(string);
    }

    @Override
    protected void paraseDecl(String string) {
        String[] stringArray = string.split("[,]?\\s+");
        String string2 = "null";
        for (String string3 : stringArray) {
            if (string3.equals("extends") || string3.equals("implements")) {
                string2 = string3;
                continue;
            }
            if (string2.equals("extends")) {
                this.superClass = this.stripGenerics(string3);
                string2 = "null";
                continue;
            }
            if (string2.equals("implements")) {
                this.interfaces.add(this.stripGenerics(string3));
                continue;
            }
            string2 = string3;
        }
    }

    private String stripGenerics(String string) {
        int n = string.indexOf(60);
        return n < 0 ? string : string.substring(0, n);
    }

    public MethodRecord addMethod(String string, int n) {
        this.theMethod = new MethodRecord(string, n, this);
        this.members.add(this.theMethod);
        return this.theMethod;
    }

    public void setMethodLoc(int n, int n2) {
        this.theMethod.addLoc(n);
        this.theMethod.setLineEnd(n2);
    }

    public void addMethodToken(String string) {
        this.theMethod.addToken(string);
    }

    public void setMethodSignature(String string) {
        this.theMethod.setSignature(string);
    }

    public void printLoc(PrintStream printStream, String string) {
        int n = 0;
        int n2 = 0;
        for (ObjectRecord objectRecord : this.members) {
            if (!objectRecord.type.equals("method")) continue;
            ++n;
            n2 += objectRecord.loc;
        }
        printStream.println(string + this + " " + n + " " + n2);
    }

    @Override
    public String errMessage() {
        String string = this.theMethod != null ? "\n" + this.theMethod.errMessage() : "";
        return super.errMessage() + string;
    }

    @Override
    public void accept(ObjectVisitor objectVisitor) {
        objectVisitor.visit(this);
    }
}

