package ash.gui.core;
import java.util.List;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.awt.Component;
import javax.swing.SwingConstants;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.SequentialGroup;
import javax.swing.GroupLayout.ParallelGroup;
import javax.swing.GroupLayout.Group;
import javax.swing.GroupLayout.Alignment;
import static javax.swing.GroupLayout.Alignment.BASELINE;
import static javax.swing.GroupLayout.Alignment.LEADING;
import static javax.swing.GroupLayout.Alignment.CENTER;
import static javax.swing.GroupLayout.Alignment.TRAILING;
import ash.util.Log;

/**
 * AshGroupPanel ́AGroupLayout ŃCAEgplȕւȕ\L
 * `ł悤ɂplp̃NXłA
 * X̃plƂɊgĎgp邱Ƃz肵ĂB
 * <p>g̕@́ARXgN^̒A܂ construct() \bh
 * I[oChāA̒ŃCAEg`B
 * CAEg`ł́AComponentƏcɃO[v邽߂ɁA
 * ό\bh setH/V(), paraB/L/C/T(), seq() gpB
 * Mbv̐ɂgap()\bhgpB
 * <p>setH/V()\bh́AR|[lgvf𐅕Ɛ͕̗
 * O[v̎wsȂ΂Ȃ炸Agp@GłB
 * ̖邽߂ form()\bhpӂB
 * GUIʂ̊ȈՂȐ̂߂ɂ form()\bh𗘗pƗǂB
 * <p>form()\bh́A񎟌̕\ɑăCAEgꍇɗpłB
 * form() ͉ό̍sɂƂAes ό̗vfɂƂ
 * line()\bhŒ`Bvf ComponentAAsg()\bh
 * `Bsg(seauential group)͕̗vf̗vfɂ܂Ƃ߂ۂ
 * gpB
 * @see javax.swing.GroupLayout
 */
@SuppressWarnings("serial")
public class AshGroupPanel extends AshPanel {
	protected GroupLayout layout;
	public AshGroupPanel() {
		Log.debug(1, "new AshGroupPanel()");
		layout = new GroupLayout(this);
		setLayout(layout);
		layout.setAutoCreateGaps(true);
		layout.setAutoCreateContainerGaps(true);
		construct();
	}
	public AshGroupPanel(int hPadding, int vPadding) {	// CA,111003
		this();
		setPadding(hPadding, vPadding);
	}
	protected void construct() {};

	private int hPadding = -1;	// ftHg̐pfBO
	private int vPadding = -1;	// ftHg̐pfBO
	private Gap hGap;			// ftHg̐Mbv
	private Gap vGap;			// ftHg̐Mbv
	/**
	 * Ɛ̃pfBOݒ肷B
	 * @param hPadding pfBO
	 * @param vPadding pfBO
	 */
	public void setPadding(int hPadding, int vPadding) {
		this.hPadding = hPadding;
		this.vPadding = vPadding;
	}
	/**
	 * ̃Mbvݒ肷B
	 * @param hGap Mbv
	 */
	public void setHGap(int hGap) { this.hGap = gap(hGap); } // CA,090824
	/**
	 * Mbvݒ肷B
	 * @param vGap Mbv
	 */
	public void setVGap(int vGap) { this.vGap = gap(vGap); } // CA,090824

	private Alignment hAlignment = LEADING;
	private Alignment vAlignment = CENTER;
	/**
	 * ̃ACgݒ肷B
	 * @param hAlignment ACg
	 */
	public void setHAlignment(Alignment hAlignment) {	// CA,090824
		this.hAlignment = hAlignment;
	}
	/**
	 * ACgݒ肷B
	 * @param vAlignment ACg
	 */
	public void setVAlignment(Alignment vAlignment) {	// CA,090824
		this.vAlignment = vAlignment;
	}

	/**
	 * s̃XgƂĒ`ꂽtH[CAEgB
	 * <pre>
	 * form := (line | gap)+
	 * line := (string | component | sg | null)+
	 * sg   := (string | component | gap)+			// sg = sequential group
	 * </pre>
	 * @param lines ܂ JComponent ̕
	 */
	@SuppressWarnings("unchecked")
	public AshGroupPanel form(Object... lines) {	// CA,111003
		List<Object> vg = new ArrayList<Object>();
		List<Object> hg = new ArrayList<Object>();
		for(Object obj : lines) {					// line(...)
			if(obj instanceof Gap) {
				vg.add(para(vAlignment, obj));
			} else if(obj instanceof List) {
				formLine(vg, hg, (List)obj);
			} else {
				throw new RuntimeException("ERROR: form: " + obj);
			}
		}
		for(int i = 0; i < hg.size(); i++) {
			Object obj = hg.get(i);
			if(obj instanceof List)					// CA,090824
				hg.set(i, para(hAlignment, ((List)obj).toArray()));
		}
		setV(vg.toArray());
		setH(hg.toArray());
		return this;								// CA,111003
	}
	@SuppressWarnings("unchecked")
	private void formLine(List<Object> vg, List<Object> hg, List columns) {
		List<Object> line = new ArrayList<Object>();
		int columnNo = 0;
		for(Object column : columns) {				// s̊evf
			if(column == null) {
			} else if(column instanceof Gap) {
				hg.add(para(hAlignment, column));
			} else if(column instanceof Component) { // label, button, ...
				line.add(column);
				addPara(hg, columnNo, column);
			} else if(column instanceof List) {		// sg(gap, label, ...)
				List seqg = (List)column;
				for(Object c : seqg) {
					if(c instanceof Component) line.add(c);
				}
				addPara(hg, columnNo, seq(seqg.toArray()));
			} else {
				throw new RuntimeException("ERROR: form line: " + column);
			}
			columnNo++;
		}
		vg.add(para(vAlignment, line.toArray()));
	}
	@SuppressWarnings("unchecked")
	private void addPara(List hg, int columnNo, Object column) {
		for(int i = hg.size(); i <= columnNo; i++)
			hg.add(new ArrayList());
		Object obj = hg.get(columnNo);
		if(obj instanceof List) {					// CA,090824
			List para = (List)obj;
			para.add(column);		// unchecked
		}
	}
	/**
	 * R|[lg̃O[v𐅕ɔzu悤ɐݒ肷B
	 */
	protected void setH(Object... objects) {
		layout.setHorizontalGroup(seq(hPadding, objects));
	}
	/**
	 * R|[lg̃O[v𐂒ɔzu悤ɐݒ肷B
	 */
	protected void setV(Object... objects) {
		layout.setVerticalGroup(seq(vPadding, objects));
	}

	/**
	 * ParallelGroup \bhFparaB/L/C/T(compo/group/gap,...)B
	 * <p>Cӌ Component, Group, ܂ Gap  ParallelGroup 
	 * BKƂāABASELINE, LEADING, CENTER, TAILING 
	 * AꂼP̓ŋʂB
	 */
	protected ParallelGroup paraB(Object... objects) {
		return para(BASELINE, objects);
	}
	protected ParallelGroup paraL(Object... objects) {
		return para(LEADING, objects);
	}
	protected ParallelGroup paraC(Object... objects) {
		return para(CENTER, objects);
	}
	protected ParallelGroup paraT(Object... objects) {
		return para(TRAILING, objects);
	}
	private ParallelGroup para(Alignment alignment, Object... objects) {
		ParallelGroup pg = layout.createParallelGroup(alignment);
		assert Log.debug(1, "==> AshGroupPanel#para(): " + alignment);
		for(Object obj : objects) {
			assert Log.debug(1, getObjectText(obj));
			if(obj instanceof Component) {
				pg.addComponent((Component)obj);
			} else if(obj instanceof String) {
				pg.addComponent(label((String)obj));
			} else if(obj instanceof Gap) {
				((Gap)obj).addTo(pg);
			} else if(obj instanceof Group) {
				pg.addGroup((Group)obj);
			} else {
				throw new RuntimeException("ERROR: para: " + obj);
			}
		}
		assert Log.debug(1, "<== AshGroupPanel#para(): " + alignment);
		return pg;
	}
	
	/**
	 * SequentialGroup \bhB
	 * <p> Cӌ Component, Group, ܂ Gap  SequentialGroup 
	 * B
	 * @param objects Cӌ̗vf̕
	 */
	protected SequentialGroup seq(Object... objects) {
		return seq(-1, objects);
	}
	/**
	 * P int^łOȏ̏ꍇ́A̒l padding B
	 * @param padding Oȏ̏ꍇpfBOlƂĎgB
	 * ̒l̏ꍇ̓ftHg̃pfBOƂȂB
	 */
	protected SequentialGroup seq(int padding, Object... objects) {
		Gap pad = gap(padding);
		SequentialGroup sg = layout.createSequentialGroup();
		assert Log.debug(1, "==> AshGroupPanel#seq()");
		if(padding >= 0) pad.addTo(sg);
		for(Object obj : objects) {
			assert Log.debug(1, getObjectText(obj));
			if(obj instanceof Component) {
				sg.addComponent((Component)obj);
			} else if(obj instanceof String) {
				sg.addComponent(label((String)obj));
			} else if(obj instanceof Gap) {
				((Gap)obj).addTo(sg);
			} else if(obj instanceof Group) {
				sg.addGroup((Group)obj);
			} else {
				throw new RuntimeException("ERROR: seq: " + obj);
			}
		}
		if(padding >= 0) pad.addTo(sg);
		assert Log.debug(1, "<== AshGroupPanel#seq()");
		return sg;
	}
	static final String COMP_FORMAT = "^([^\\[]+)\\[.*text=([^,\\]]*)";
	// <????>[...text=<????>, ...]
	static private Pattern compPat = Pattern.compile(COMP_FORMAT);
	/**
	 * GUIR|[lg̃eLXg擾B
	 * fobOp\bh(debug 1 ŗLɂȂ)
	 */
	protected static String getObjectText(Object obj) {
		String s = obj.toString();
		Matcher m = compPat.matcher(s);
		if(!m.find()) return s;
		return m.group(1) + " [" + m.group(2) + "]";
	}

	/**
	 * Component uB
	 */
	protected void replace(Component compo, Component newCompo) {
		layout.replace(compo, newCompo);
	}

	/**
	 * Cӌ Component 𓯈TCYɂ
	 */
	protected void linkSize(Component... components) {
		layout.linkSize(components);
	}
	/**
	 * Cӌ Component 𓯈̕ɂ
	 */
	protected void linkSizeH(Component... components) {
		layout.linkSize(SwingConstants.HORIZONTAL, components);
	}
	/**
	 * Cӌ Component 𓯈̍ɂ
	 */
	protected void linkSizeV(Component... components) {
		layout.linkSize(SwingConstants.VERTICAL, components);
	}
}
