package ash.reverse.struct;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.HashSet;
import ash.reverse.struct.ObjectAggregator;

/**
 * PJava\[Xt@Cɑ΂Ĉȉ̏ǗB
 * <ul>
 * <li> pbP[W
 * <li> ̃t@CŒ`ꂽNXEC^tF[XE񋓌^̌^̃Xg
 * <li> ̌^̎ŎQƂ^肷邽߂ɕKvȃpbP[W̃Xg
 * </ul>
 * importŌ^ꂽpbP[W͌^ƃpbP[W̃}bvŊǗB
 * If}h^錾importɑ΂Ă̓pbP[WZbgŊǗB
 * 
 */
public class FileRecord extends GroupRecord {
	private Set<String> onDemandSet = new HashSet<String>();
	public Set<String> onDemandSet() { return onDemandSet; }
	private Map<String,String> typePkgMap = new LinkedHashMap<String,String>();
	public Map<String,String> typePkgMap() { return typePkgMap; }
	private String pkgname = "";
	public void pkgname(String pkgname) { this.pkgname = pkgname; }
	public String pkgname() { return pkgname; }
	@Override public String fqcn() { return pkgname; }

	public FileRecord(String name) {
		super("file", name, 1, null);
	}

	/**
	 * importŐ錾ꂽ^Ƃ̌^`ĂpbP[Wo^B
	 * import͒P^錾(import a.b.T)ƃIf}h^錾(import a.b.*)
	 * ̌`BP^錾̏ꍇtypePkgMapɌ^ƃpbP[WA
	 * If}h^錾̏ꍇ́AonDemandSetɃpbP[Wo^B
	 * staticC|[g錾͖B
	 * @param importDecl
	 */
	public void addImportDecl(String importDecl) {
		String tokens[] = importDecl.split("\\s+");
		String decl = tokens[0];
		if(!decl.equals("static")) {
			int index = decl.lastIndexOf('.');
			String pkg = decl.substring(0, index);
			String typeName = decl.substring(index+1);
			if(typeName.equals("*")) {
				onDemandSet.add(pkg);
			} else {
				typePkgMap.put(typeName, pkg);
			}
		}
	}
	/**
	 * ^pbP[W𓾂B
	 * @param typeName ^
	 */
	public String getPackage(String typeName) {
		return typePkgMap.get(typeName);
	}

	public String fqcn(String name) {
		String pkgname = typePkgMap.get(name);
		return (pkgname != null) ? (pkgname + "." + name) : null;
	}

	/**
	 * pbP[W̏Wvo͂B
	 * @param aggregator K͏̏WvƏo͂sAOQ[^
	 * @param pre AOQ[^̃^Cg\̃vtBbNX
	 */
	public void printTitle(ObjectAggregator aggregator, String pre) {
		if(name == null) return;
		// t@CASsALsANXA\bhA\bhs
		aggregator.print(pre + name, endLine, loc, 
						 members.size(), countMethods(), sumMethodLoc());
	}

	/**
	 * Visitorp^[̎󂯓ꑤ\bhBK҂󂯓B
	 * @param visitor ̃t@CL^{K
	 */
	@Override public void accept(ObjectVisitor visitor) {
		visitor.visit(this);
	}
}
