package ash.reverse.struct;
import java.util.List;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.io.PrintStream;
import ash.reverse.parser.Mod;
import ash.reverse.parser.Visibility;

/**
 * Java\[XR[h̃NXێf[^\̃x[XNXB
 * <pre>
 *	ObjectRecord <------------+
 *	  +- GroupRecord----------+
 *	  |    |- FileRecord -----+
 *	  |    +- ClassRecord ----+
 *	  +- MethodRecord
 *	  +- FieldRecord
 * </pre>
 * Compositep^[Componennt̖ʂB<br>
 * Visitorp^[̎󂯓ꑤ̖ʂB
 */
public abstract class ObjectRecord {
	final static String SEP = "\t";			// UMLt@C`̃Zp[^
	GroupRecord owner;		// ̃IuWFNgLĂO[v
	String type;			// package, class, interface, enum, method, field
	String name = "";		// OipbP[WANXA\bhȂǁj
	int loc = 0;			// LR[hs
	int startLine;			// `̊Jnsԍ
	int endLine;			// `̏Isԍ
	String signature;		// `
	Visibility visibility;	// 
	int modifiers;			// Cq

	/* ANZbT̒` */
	public GroupRecord owner() { return owner; }
	public String type() { return type; }
	public void type(String type) { this.type = type; }
	public String name() { return name; }
	public void name(String name) { this.name = name; }
	public String signature() { return signature; }
	public Visibility visibility() { return visibility; }
	public void visibility(Visibility vis) { this.visibility = vis; }
	public boolean isPublic() { return (visibility == Visibility.PUBLIC); }
	public int modifiers() { return modifiers; }
	public void modifiers(int modifiers) { this.modifiers = modifiers; }
	public boolean isAbstract() { return Mod.ABSTRACT.in(modifiers); }
	public boolean isInterface() { return false; }

	public ObjectRecord root() { return (owner != null) ? owner.root() : this; }

	/**
	 * SCԂB
	 * @return SC
	 */
	public String fqcn() {
		if(owner == null) return name;
		String ownerpath = owner.fqcn();
		if(ownerpath == null || ownerpath.isEmpty()) return name;
		return owner.fqcn() + "." + name;
	}

	ObjectRecord(String type, String name, int lineno, GroupRecord owner) {
		this.type = type;
		this.name = name;
		this.startLine = lineno;
		this.owner = owner;
	}

	/** LR[hsǉB */
	public void addLoc(int n) { loc += n; }
	/** Isԍݒ肷B */
	public void setLineEnd(int lineno) { endLine = lineno; }

	/** \bhJEgB */
	protected int countMethods() { return 0; }
	/** \bh̍sWvB */
	protected int sumMethodLoc() { return 0; }

	/** vgo͂镶gݗĂB */
	@Override public String toString() {
		return type + " " + name + " " + loc;
	}
	/** G[bZ[W̕gݗĂB */
	public String errMessage() {
		return type + " " + name + " at line " + startLine;
	}

	/**
	 * `ݒ肷B̉͂̕֋X̂߂ɁA^p[^
	 * JMJbR(<>)̕񒆂ɋ󔒕񂪊܂܂Ȃ悤ɁA
	 * HB
	 * <pre>
	 * Map<String, Color> --> Map<String,Color>
	 * Store<T extends Entity> --> Store<T+extends+Entity>
	 * </pre>
	 */
	public void setSignature(final String sig) {
		StringBuilder sb = new StringBuilder();
		int level = 0;
		char b = 0;
		for(int i = 0; i < sig.length(); i++) {
			char c = sig.charAt(i);
			if(level > 0) {
				if(c == ' ') {
					// [,<> ] Ɍ㑱󔒕XLbvB
					if(b == ',' || b == '<' || b == '>' || b == SPACEHOLDER)
						continue;
					c = SPACEHOLDER;
				}
			}
			sb.append(c);
			if(c == '<') level++;
			if(c == '>') level--;
			b = c;
		}
		signature = sb.toString();
		paraseDecl(signature);
	}
	static final char SPACEHOLDER = '+';

	/**
	 * Ame[V菜VOj`ԂB
	 * @return VOj`
	 */
	public String getSignature() {
		int i = signature.lastIndexOf('\t');
		return (i < 0) ? signature : signature.substring(i+1);
	}

	/**
	 * \bh܂̓tB[h̐錾͂Af[^^ typeɐݒ肷B
	 * @param decl o錾
	 * <pre>
	 * \bh錾̗: T<E,K> name(T1 p1, T2 p2, ) ...
	 * tB[h錾̗: T<E,K> name ...
	 * </pre>
	 */
	protected void paraseDecl(String decl) {
		String[] tokens = extractDecl(decl).split("[\\s(]");
		String prevToken = "null";
		for(String token : tokens) {
			if(token.equals(name)) {
				type = prevToken;
			} else if(Mod.mask(token) == 0 && Visibility.undef(token) ) {
				prevToken = token;
			}
		}
	}
	/**
	 * 錾Ame[Vƃ\bḧ菜B
	 */
	private String extractDecl(String decl) {
		int i1 = decl.lastIndexOf('\t');
		if(i1 >= 0) decl = decl.substring(i1+1);
		int i2 = decl.indexOf('(');
		if(i2 >= 0) decl = decl.substring(0, i2);
		return decl;
	}

	/** {̂̋LqvfłWORD^g[ÑXg */
	private List<String> tokens = new ArrayList<String>();
	/**
	 * {̂Lqg[NǉB
	 * @param sval g[N
	 */
	public void addToken(String sval) { tokens.add(sval); }
	/**
	 * {̂Lqg[NXgԂB
	 * @return g[ÑXg
	 */
	public List<String> getTokens() { return tokens; }

	/**
	 * Visitorp^[̎󂯓ꑤ\bh
	 * @param visitor
	 */
	abstract public void accept(ObjectVisitor visitor);

	/**
	 * fobOpg[X
	 * @param msg bZ[W
	 */
	boolean trace(Object msg) {
		System.err.println(msg);
		return true;
	}
}
